/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.grouping;

import io.github.springwolf.asyncapi.v3.model.AsyncAPI;
import io.github.springwolf.core.asyncapi.grouping.GroupingService;
import io.github.springwolf.core.configuration.docket.AsyncApiGroup;
import io.github.springwolf.core.configuration.docket.AsyncApiInfoMapper;
import io.github.springwolf.core.configuration.properties.SpringwolfConfigProperties;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class AsyncApiGroupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncApiGroupService.class);
    private final SpringwolfConfigProperties springwolfConfigProperties;
    private final GroupingService groupingService;

    public Map<String, AsyncAPI> group(AsyncAPI asyncAPI) {
        return this.getAsyncApiGroups().map(group -> {
            AsyncAPI groupedApi = this.groupingService.groupAPI(asyncAPI, (AsyncApiGroup)group);
            groupedApi.setInfo(AsyncApiInfoMapper.mergeInfo(groupedApi.getInfo(), group.getGroupInfo()));
            return Map.entry(group.getGroupName(), groupedApi);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Stream<AsyncApiGroup> getAsyncApiGroups() {
        return this.springwolfConfigProperties.getDocket().getGroupConfigs().stream().map(AsyncApiGroupService::toGroupConfigAndValidate);
    }

    private static AsyncApiGroup toGroupConfigAndValidate(SpringwolfConfigProperties.ConfigDocket.Group group) {
        String groupName = group.getGroup();
        List<Pattern> channelNameToMatch = group.getChannelNameToMatch().stream().map(Pattern::compile).toList();
        List<Pattern> messageNameToMatch = group.getMessageNameToMatch().stream().map(Pattern::compile).toList();
        if (!StringUtils.hasText((String)groupName)) {
            throw new IllegalArgumentException("AsyncApiGroup must have a name set in configuration");
        }
        int allItemCount = group.getActionToMatch().size() + group.getChannelNameToMatch().size() + group.getMessageNameToMatch().size();
        if (allItemCount != 0 && group.getActionToMatch().size() != allItemCount && channelNameToMatch.size() != allItemCount && messageNameToMatch.size() != allItemCount) {
            throw new IllegalArgumentException("AsyncApiGroup %s must specify at most one filter criteria".formatted(groupName));
        }
        AsyncApiGroup asyncApiGroup = AsyncApiGroup.builder().groupName(groupName).groupInfo(AsyncApiInfoMapper.mapInfo(group.getInfo())).operationActionsToKeep(group.getActionToMatch()).channelNamesToKeep(channelNameToMatch).messageNamesToKeep(messageNameToMatch).build();
        log.debug("Loaded AsyncApiGroup from configuration: {}", (Object)asyncApiGroup);
        return asyncApiGroup;
    }

    @Generated
    public AsyncApiGroupService(SpringwolfConfigProperties springwolfConfigProperties, GroupingService groupingService) {
        this.springwolfConfigProperties = springwolfConfigProperties;
        this.groupingService = groupingService;
    }
}

