/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.bindings.operations;

import io.github.springwolf.core.asyncapi.annotations.AsyncOperationBinding;
import io.github.springwolf.core.asyncapi.scanners.bindings.operations.OperationBindingProcessor;
import io.github.springwolf.core.asyncapi.scanners.bindings.operations.ProcessedOperationBinding;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public abstract class AbstractOperationBindingProcessor<A>
implements OperationBindingProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractOperationBindingProcessor.class);
    private final StringValueResolver stringValueResolver;
    private final Class<A> specificAnnotationClazz = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];

    @Override
    public Optional<ProcessedOperationBinding> process(Method method) {
        return Arrays.stream(method.getAnnotations()).filter(annotation -> annotation.annotationType().isAnnotationPresent(AsyncOperationBinding.class)).flatMap(this::tryCast).findAny().map(this::mapToOperationBinding);
    }

    private Stream<A> tryCast(Annotation obj) {
        try {
            return Stream.of(this.specificAnnotationClazz.cast(obj));
        }
        catch (ClassCastException ex) {
            log.trace("Method has multiple bindings defined.", (Throwable)ex);
            return Stream.empty();
        }
    }

    protected abstract ProcessedOperationBinding mapToOperationBinding(A var1);

    protected String resolveOrNull(String stringValue) {
        return StringUtils.hasText((String)stringValue) ? this.stringValueResolver.resolveStringValue(stringValue) : null;
    }

    @Generated
    public AbstractOperationBindingProcessor(StringValueResolver stringValueResolver) {
        this.stringValueResolver = stringValueResolver;
    }
}

