/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.channels;

import io.github.springwolf.asyncapi.v3.model.channel.ChannelObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChannelMerger {
    private ChannelMerger() {
    }

    public static Map<String, ChannelObject> mergeChannels(List<ChannelObject> channels) {
        HashMap<String, ChannelObject> mergedChannels = new HashMap<String, ChannelObject>();
        for (ChannelObject channel : channels) {
            if (!mergedChannels.containsKey(channel.getChannelId())) {
                mergedChannels.put(channel.getChannelId(), channel);
                continue;
            }
            ChannelObject existingChannel = (ChannelObject)mergedChannels.get(channel.getChannelId());
            ChannelObject mergedChannel = ChannelMerger.mergeChannel(existingChannel, channel);
            mergedChannels.put(mergedChannel.getChannelId(), mergedChannel);
        }
        return mergedChannels;
    }

    private static ChannelObject mergeChannel(ChannelObject channel, ChannelObject otherChannel) {
        ChannelObject mergedChannel = channel != null ? channel : otherChannel;
        ChannelMerger.mergeMessages(channel, otherChannel, mergedChannel);
        ChannelMerger.mergeBindings(channel, otherChannel, mergedChannel);
        return mergedChannel;
    }

    private static void mergeMessages(ChannelObject channel, ChannelObject otherChannel, ChannelObject mergedChannel) {
        Map channelMessages = channel.getMessages();
        Map otherChannelMessages = otherChannel.getMessages();
        HashMap mergedMessages = new HashMap();
        if (channelMessages != null) {
            mergedMessages.putAll(channelMessages);
        }
        if (otherChannelMessages != null) {
            otherChannelMessages.forEach(mergedMessages::putIfAbsent);
        }
        if (!mergedMessages.isEmpty()) {
            mergedChannel.setMessages(mergedMessages);
        }
    }

    private static void mergeBindings(ChannelObject channel, ChannelObject otherChannel, ChannelObject mergedChannel) {
        Map channelBindings = channel.getBindings();
        Map otherChannelBindings = otherChannel.getBindings();
        HashMap mergedBindings = new HashMap();
        if (channelBindings != null) {
            mergedBindings.putAll(channelBindings);
        }
        if (otherChannelBindings != null) {
            otherChannelBindings.forEach(mergedBindings::putIfAbsent);
        }
        if (!mergedBindings.isEmpty()) {
            mergedChannel.setBindings(mergedBindings);
        }
    }
}

