/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.classes.spring;

import io.github.springwolf.core.asyncapi.scanners.classes.ClassScanner;
import io.github.springwolf.core.asyncapi.scanners.classes.spring.annotations.ClassScannerUtil;
import io.github.springwolf.core.configuration.docket.AsyncApiDocketService;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.springframework.core.env.Environment;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

public class ComponentClassScanner
implements ClassScanner {
    private final AsyncApiDocketService asyncApiDocketService;
    private final Environment environment;

    @Override
    public Set<Class<?>> scan() {
        String basePackages = this.asyncApiDocketService.getAsyncApiDocket().getBasePackage();
        if (!StringUtils.hasText((String)basePackages)) {
            throw new IllegalArgumentException("Base package must not be blank");
        }
        AnnotationTypeFilter filter = new AnnotationTypeFilter(Component.class);
        return new HashSet(ClassScannerUtil.getClasses(basePackages, (TypeFilter)filter, this.environment));
    }

    @Generated
    public ComponentClassScanner(AsyncApiDocketService asyncApiDocketService, Environment environment) {
        this.asyncApiDocketService = asyncApiDocketService;
        this.environment = environment;
    }
}

