/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common.message;

import io.github.springwolf.asyncapi.v3.bindings.MessageBinding;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageHeaders;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessagePayload;
import io.github.springwolf.asyncapi.v3.model.schema.MultiFormatSchema;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaReference;
import io.github.springwolf.core.asyncapi.components.ComponentsService;
import io.github.springwolf.core.asyncapi.scanners.bindings.BindingFactory;
import io.github.springwolf.core.asyncapi.scanners.common.headers.AsyncHeadersBuilder;
import io.github.springwolf.core.asyncapi.scanners.common.headers.HeaderSchemaObjectMerger;
import io.github.springwolf.core.asyncapi.scanners.common.payload.PayloadSchemaObject;
import java.lang.annotation.Annotation;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringAnnotationMessageService<MethodAnnotation extends Annotation> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringAnnotationMessageService.class);
    private final BindingFactory<MethodAnnotation> bindingFactory;
    private final AsyncHeadersBuilder asyncHeadersBuilder;
    private final ComponentsService componentsService;

    public MessageObject buildMessage(MethodAnnotation annotation, PayloadSchemaObject payloadSchema, SchemaObject headers) {
        SchemaObject headerSchema = this.asyncHeadersBuilder.buildHeaders(payloadSchema);
        SchemaObject mergedHeaderSchema = HeaderSchemaObjectMerger.merge(headerSchema, headers);
        String headerModelName = this.componentsService.registerSchema(mergedHeaderSchema);
        Map<String, MessageBinding> messageBinding = this.bindingFactory.buildMessageBinding(annotation, mergedHeaderSchema);
        MessagePayload payload = MessagePayload.of((MultiFormatSchema)MultiFormatSchema.builder().schema(payloadSchema.payload()).build());
        MessageObject message = MessageObject.builder().messageId(payloadSchema.name()).name(payloadSchema.name()).title(payloadSchema.title()).description(null).payload(payload).headers(MessageHeaders.of((SchemaReference)SchemaReference.toSchema((String)headerModelName))).bindings(messageBinding).build();
        this.componentsService.registerMessage(message);
        return message;
    }

    @Generated
    public SpringAnnotationMessageService(BindingFactory<MethodAnnotation> bindingFactory, AsyncHeadersBuilder asyncHeadersBuilder, ComponentsService componentsService) {
        this.bindingFactory = bindingFactory;
        this.asyncHeadersBuilder = asyncHeadersBuilder;
        this.componentsService = componentsService;
    }
}

