/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common.operation;

import io.github.springwolf.asyncapi.v3.bindings.OperationBinding;
import io.github.springwolf.asyncapi.v3.model.channel.ChannelReference;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageObject;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.asyncapi.v3.model.operation.Operation;
import io.github.springwolf.asyncapi.v3.model.operation.OperationAction;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import io.github.springwolf.core.asyncapi.scanners.bindings.BindingFactory;
import io.github.springwolf.core.asyncapi.scanners.common.annotation.MethodAndAnnotation;
import io.github.springwolf.core.asyncapi.scanners.common.message.SpringAnnotationMessageService;
import io.github.springwolf.core.asyncapi.scanners.common.payload.PayloadSchemaObject;
import io.github.springwolf.core.asyncapi.scanners.operations.OperationIdHelper;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class SpringAnnotationOperationService<MethodAnnotation extends Annotation> {
    private final BindingFactory<MethodAnnotation> bindingFactory;
    private final SpringAnnotationMessageService<MethodAnnotation> springAnnotationMessageService;

    public Operation buildOperation(MethodAndAnnotation<MethodAnnotation> annotation, PayloadSchemaObject payloadType, SchemaObject headerSchema) {
        String channelId = this.bindingFactory.getChannelId((Annotation)annotation.annotation());
        String operationId = OperationIdHelper.buildOperationId(channelId, OperationAction.RECEIVE, annotation.method().getName());
        MessageObject message = this.springAnnotationMessageService.buildMessage((Annotation)annotation.annotation(), payloadType, headerSchema);
        Map<String, OperationBinding> operationBinding = this.bindingFactory.buildOperationBinding((Annotation)annotation.annotation());
        HashMap<String, OperationBinding> opBinding = operationBinding != null ? new HashMap<String, OperationBinding>(operationBinding) : null;
        return Operation.builder().operationId(operationId).action(OperationAction.RECEIVE).channel(ChannelReference.fromChannel((String)channelId)).messages(List.of(MessageReference.toChannelMessage((String)channelId, (MessageObject)message))).bindings(opBinding).build();
    }

    @Generated
    public SpringAnnotationOperationService(BindingFactory<MethodAnnotation> bindingFactory, SpringAnnotationMessageService<MethodAnnotation> springAnnotationMessageService) {
        this.bindingFactory = bindingFactory;
        this.springAnnotationMessageService = springAnnotationMessageService;
    }
}

