/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.asyncapi.scanners.common.operation;

import io.github.springwolf.asyncapi.v3.bindings.OperationBinding;
import io.github.springwolf.asyncapi.v3.model.channel.ChannelReference;
import io.github.springwolf.asyncapi.v3.model.channel.message.MessageReference;
import io.github.springwolf.asyncapi.v3.model.operation.Operation;
import io.github.springwolf.asyncapi.v3.model.operation.OperationAction;
import io.github.springwolf.core.asyncapi.scanners.bindings.BindingFactory;
import io.github.springwolf.core.asyncapi.scanners.common.message.SpringAnnotationMessagesService;
import io.github.springwolf.core.asyncapi.scanners.operations.OperationIdHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;

public class SpringAnnotationOperationsService<ClassAnnotation extends Annotation> {
    private final BindingFactory<ClassAnnotation> bindingFactory;
    private final SpringAnnotationMessagesService<ClassAnnotation> springAnnotationMessagesService;

    public Operation buildOperation(ClassAnnotation classAnnotation, Class<?> component, Set<Method> methods) {
        Map<String, MessageReference> messages = this.springAnnotationMessagesService.buildMessages(classAnnotation, methods, SpringAnnotationMessagesService.MessageType.OPERATION);
        Map<String, OperationBinding> operationBinding = this.bindingFactory.buildOperationBinding(classAnnotation);
        HashMap<String, OperationBinding> opBinding = operationBinding != null ? new HashMap<String, OperationBinding>(operationBinding) : null;
        String channelId = this.bindingFactory.getChannelId(classAnnotation);
        String operationId = OperationIdHelper.buildOperationId(channelId, OperationAction.RECEIVE, component.getSimpleName());
        return Operation.builder().operationId(operationId).action(OperationAction.RECEIVE).channel(ChannelReference.fromChannel((String)channelId)).messages(messages.values().stream().toList()).bindings(opBinding).build();
    }

    @Generated
    public SpringAnnotationOperationsService(BindingFactory<ClassAnnotation> bindingFactory, SpringAnnotationMessagesService<ClassAnnotation> springAnnotationMessagesService) {
        this.bindingFactory = bindingFactory;
        this.springAnnotationMessagesService = springAnnotationMessagesService;
    }
}

