/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.configuration.properties;

import io.github.springwolf.asyncapi.v3.model.info.Contact;
import io.github.springwolf.asyncapi.v3.model.info.License;
import io.github.springwolf.asyncapi.v3.model.operation.OperationAction;
import io.github.springwolf.asyncapi.v3.model.server.Server;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="springwolf")
public class SpringwolfConfigProperties {
    private boolean enabled = true;
    private InitMode initMode = InitMode.FAIL_FAST;
    private boolean useFqn = true;
    private boolean studioCompatibility = true;
    @Deprecated(forRemoval=true)
    private Paths paths = new Paths();
    private Path path = new Path();
    @Nullable
    private Endpoint endpoint;
    private ConfigDocket docket = new ConfigDocket();
    private UI ui = new UI();
    @Nullable
    private Scanner scanner;
    @Nullable
    private Payload payload = new Payload();

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public InitMode getInitMode() {
        return this.initMode;
    }

    @Generated
    public boolean isUseFqn() {
        return this.useFqn;
    }

    @Generated
    public boolean isStudioCompatibility() {
        return this.studioCompatibility;
    }

    @Deprecated
    @Generated
    public Paths getPaths() {
        return this.paths;
    }

    @Generated
    public Path getPath() {
        return this.path;
    }

    @Nullable
    @Generated
    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public ConfigDocket getDocket() {
        return this.docket;
    }

    @Generated
    public UI getUi() {
        return this.ui;
    }

    @Nullable
    @Generated
    public Scanner getScanner() {
        return this.scanner;
    }

    @Nullable
    @Generated
    public Payload getPayload() {
        return this.payload;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setInitMode(InitMode initMode) {
        this.initMode = initMode;
    }

    @Generated
    public void setUseFqn(boolean useFqn) {
        this.useFqn = useFqn;
    }

    @Generated
    public void setStudioCompatibility(boolean studioCompatibility) {
        this.studioCompatibility = studioCompatibility;
    }

    @Deprecated
    @Generated
    public void setPaths(Paths paths) {
        this.paths = paths;
    }

    @Generated
    public void setPath(Path path) {
        this.path = path;
    }

    @Generated
    public void setEndpoint(@Nullable Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Generated
    public void setDocket(ConfigDocket docket) {
        this.docket = docket;
    }

    @Generated
    public void setUi(UI ui) {
        this.ui = ui;
    }

    @Generated
    public void setScanner(@Nullable Scanner scanner) {
        this.scanner = scanner;
    }

    @Generated
    public void setPayload(@Nullable Payload payload) {
        this.payload = payload;
    }

    public static enum InitMode {
        FAIL_FAST,
        BACKGROUND;

    }

    public static class Paths {
        @Deprecated(forRemoval=true)
        private String docs = "/springwolf/docs";

        @Deprecated
        @Generated
        public String getDocs() {
            return this.docs;
        }

        @Deprecated
        @Generated
        public void setDocs(String docs) {
            this.docs = docs;
        }
    }

    public static class Path {
        private String base = "/springwolf";
        private String docs = "/docs";

        @Generated
        public String getBase() {
            return this.base;
        }

        @Generated
        public String getDocs() {
            return this.docs;
        }

        @Generated
        public void setBase(String base) {
            this.base = base;
        }

        @Generated
        public void setDocs(String docs) {
            this.docs = docs;
        }
    }

    public static class ConfigDocket {
        public static final String DEFAULT_CONTENT_TYPE = "application/json";
        @Nullable
        private String basePackage;
        @Nullable
        private String id;
        private String defaultContentType = "application/json";
        @Nullable
        private Map<String, Server> servers;
        @Nullable
        private Info info;
        private List<Group> groupConfigs = List.of();

        @Nullable
        @Generated
        public String getBasePackage() {
            return this.basePackage;
        }

        @Nullable
        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public String getDefaultContentType() {
            return this.defaultContentType;
        }

        @Nullable
        @Generated
        public Map<String, Server> getServers() {
            return this.servers;
        }

        @Nullable
        @Generated
        public Info getInfo() {
            return this.info;
        }

        @Generated
        public List<Group> getGroupConfigs() {
            return this.groupConfigs;
        }

        @Generated
        public void setBasePackage(@Nullable String basePackage) {
            this.basePackage = basePackage;
        }

        @Generated
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @Generated
        public void setDefaultContentType(String defaultContentType) {
            this.defaultContentType = defaultContentType;
        }

        @Generated
        public void setServers(@Nullable Map<String, Server> servers) {
            this.servers = servers;
        }

        @Generated
        public void setInfo(@Nullable Info info) {
            this.info = info;
        }

        @Generated
        public void setGroupConfigs(List<Group> groupConfigs) {
            this.groupConfigs = groupConfigs;
        }

        public static class Info {
            @Nullable
            private String title;
            @Nullable
            private String version;
            @Nullable
            private String description;
            @Nullable
            private String termsOfService;
            @NestedConfigurationProperty
            @Nullable
            private Contact contact;
            @NestedConfigurationProperty
            @Nullable
            private License license;
            private Map<String, String> extensionFields = Map.of("x-generator", "springwolf");

            @Nullable
            @Generated
            public String getTitle() {
                return this.title;
            }

            @Nullable
            @Generated
            public String getVersion() {
                return this.version;
            }

            @Nullable
            @Generated
            public String getDescription() {
                return this.description;
            }

            @Nullable
            @Generated
            public String getTermsOfService() {
                return this.termsOfService;
            }

            @Nullable
            @Generated
            public Contact getContact() {
                return this.contact;
            }

            @Nullable
            @Generated
            public License getLicense() {
                return this.license;
            }

            @Generated
            public Map<String, String> getExtensionFields() {
                return this.extensionFields;
            }

            @Generated
            public void setTitle(@Nullable String title) {
                this.title = title;
            }

            @Generated
            public void setVersion(@Nullable String version) {
                this.version = version;
            }

            @Generated
            public void setDescription(@Nullable String description) {
                this.description = description;
            }

            @Generated
            public void setTermsOfService(@Nullable String termsOfService) {
                this.termsOfService = termsOfService;
            }

            @Generated
            public void setContact(@Nullable Contact contact) {
                this.contact = contact;
            }

            @Generated
            public void setLicense(@Nullable License license) {
                this.license = license;
            }

            @Generated
            public void setExtensionFields(Map<String, String> extensionFields) {
                this.extensionFields = extensionFields;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Info)) {
                    return false;
                }
                Info other = (Info)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$title = this.getTitle();
                String other$title = other.getTitle();
                if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                    return false;
                }
                String this$version = this.getVersion();
                String other$version = other.getVersion();
                if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                    return false;
                }
                String this$description = this.getDescription();
                String other$description = other.getDescription();
                if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
                    return false;
                }
                String this$termsOfService = this.getTermsOfService();
                String other$termsOfService = other.getTermsOfService();
                if (this$termsOfService == null ? other$termsOfService != null : !this$termsOfService.equals(other$termsOfService)) {
                    return false;
                }
                Contact this$contact = this.getContact();
                Contact other$contact = other.getContact();
                if (this$contact == null ? other$contact != null : !this$contact.equals(other$contact)) {
                    return false;
                }
                License this$license = this.getLicense();
                License other$license = other.getLicense();
                if (this$license == null ? other$license != null : !this$license.equals(other$license)) {
                    return false;
                }
                Map<String, String> this$extensionFields = this.getExtensionFields();
                Map<String, String> other$extensionFields = other.getExtensionFields();
                return !(this$extensionFields == null ? other$extensionFields != null : !((Object)this$extensionFields).equals(other$extensionFields));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Info;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $title = this.getTitle();
                result = result * 59 + ($title == null ? 43 : $title.hashCode());
                String $version = this.getVersion();
                result = result * 59 + ($version == null ? 43 : $version.hashCode());
                String $description = this.getDescription();
                result = result * 59 + ($description == null ? 43 : $description.hashCode());
                String $termsOfService = this.getTermsOfService();
                result = result * 59 + ($termsOfService == null ? 43 : $termsOfService.hashCode());
                Contact $contact = this.getContact();
                result = result * 59 + ($contact == null ? 43 : $contact.hashCode());
                License $license = this.getLicense();
                result = result * 59 + ($license == null ? 43 : $license.hashCode());
                Map<String, String> $extensionFields = this.getExtensionFields();
                result = result * 59 + ($extensionFields == null ? 43 : ((Object)$extensionFields).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "SpringwolfConfigProperties.ConfigDocket.Info(title=" + this.getTitle() + ", version=" + this.getVersion() + ", description=" + this.getDescription() + ", termsOfService=" + this.getTermsOfService() + ", contact=" + String.valueOf(this.getContact()) + ", license=" + String.valueOf(this.getLicense()) + ", extensionFields=" + String.valueOf(this.getExtensionFields()) + ")";
            }
        }

        public static class Group {
            private String group = "";
            private Info info = new Info();
            private List<OperationAction> actionToMatch = Collections.emptyList();
            private List<String> channelNameToMatch = Collections.emptyList();
            private List<String> messageNameToMatch = Collections.emptyList();

            @Generated
            public String getGroup() {
                return this.group;
            }

            @Generated
            public Info getInfo() {
                return this.info;
            }

            @Generated
            public List<OperationAction> getActionToMatch() {
                return this.actionToMatch;
            }

            @Generated
            public List<String> getChannelNameToMatch() {
                return this.channelNameToMatch;
            }

            @Generated
            public List<String> getMessageNameToMatch() {
                return this.messageNameToMatch;
            }

            @Generated
            public void setGroup(String group) {
                this.group = group;
            }

            @Generated
            public void setInfo(Info info) {
                this.info = info;
            }

            @Generated
            public void setActionToMatch(List<OperationAction> actionToMatch) {
                this.actionToMatch = actionToMatch;
            }

            @Generated
            public void setChannelNameToMatch(List<String> channelNameToMatch) {
                this.channelNameToMatch = channelNameToMatch;
            }

            @Generated
            public void setMessageNameToMatch(List<String> messageNameToMatch) {
                this.messageNameToMatch = messageNameToMatch;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Group)) {
                    return false;
                }
                Group other = (Group)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$group = this.getGroup();
                String other$group = other.getGroup();
                if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
                    return false;
                }
                Info this$info = this.getInfo();
                Info other$info = other.getInfo();
                if (this$info == null ? other$info != null : !((Object)this$info).equals(other$info)) {
                    return false;
                }
                List<OperationAction> this$actionToMatch = this.getActionToMatch();
                List<OperationAction> other$actionToMatch = other.getActionToMatch();
                if (this$actionToMatch == null ? other$actionToMatch != null : !((Object)this$actionToMatch).equals(other$actionToMatch)) {
                    return false;
                }
                List<String> this$channelNameToMatch = this.getChannelNameToMatch();
                List<String> other$channelNameToMatch = other.getChannelNameToMatch();
                if (this$channelNameToMatch == null ? other$channelNameToMatch != null : !((Object)this$channelNameToMatch).equals(other$channelNameToMatch)) {
                    return false;
                }
                List<String> this$messageNameToMatch = this.getMessageNameToMatch();
                List<String> other$messageNameToMatch = other.getMessageNameToMatch();
                return !(this$messageNameToMatch == null ? other$messageNameToMatch != null : !((Object)this$messageNameToMatch).equals(other$messageNameToMatch));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof Group;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $group = this.getGroup();
                result = result * 59 + ($group == null ? 43 : $group.hashCode());
                Info $info = this.getInfo();
                result = result * 59 + ($info == null ? 43 : ((Object)$info).hashCode());
                List<OperationAction> $actionToMatch = this.getActionToMatch();
                result = result * 59 + ($actionToMatch == null ? 43 : ((Object)$actionToMatch).hashCode());
                List<String> $channelNameToMatch = this.getChannelNameToMatch();
                result = result * 59 + ($channelNameToMatch == null ? 43 : ((Object)$channelNameToMatch).hashCode());
                List<String> $messageNameToMatch = this.getMessageNameToMatch();
                result = result * 59 + ($messageNameToMatch == null ? 43 : ((Object)$messageNameToMatch).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "SpringwolfConfigProperties.ConfigDocket.Group(group=" + this.getGroup() + ", info=" + String.valueOf(this.getInfo()) + ", actionToMatch=" + String.valueOf(this.getActionToMatch()) + ", channelNameToMatch=" + String.valueOf(this.getChannelNameToMatch()) + ", messageNameToMatch=" + String.valueOf(this.getMessageNameToMatch()) + ")";
            }
        }
    }

    public static class UI {
        private Defaults defaults = new Defaults();

        @Generated
        public Defaults getDefaults() {
            return this.defaults;
        }

        @Generated
        public void setDefaults(Defaults defaults) {
            this.defaults = defaults;
        }

        public static class Defaults {
            private boolean showBindings = true;
            private boolean showHeaders = true;

            @Generated
            public boolean isShowBindings() {
                return this.showBindings;
            }

            @Generated
            public boolean isShowHeaders() {
                return this.showHeaders;
            }

            @Generated
            public void setShowBindings(boolean showBindings) {
                this.showBindings = showBindings;
            }

            @Generated
            public void setShowHeaders(boolean showHeaders) {
                this.showHeaders = showHeaders;
            }
        }
    }

    public static class Payload {
        private Map<String, Integer> extractableClasses = Map.of("java.util.function.Consumer", 0, "java.util.function.Supplier", 0, "org.springframework.messaging.Message", 0, "org.apache.kafka.streams.kstream.KStream", 1, "java.util.List", 0, "java.util.Optional", 0);

        public void setExtractableClasses(Map<String, Integer> extractableClasses) {
            this.extractableClasses = extractableClasses.entrySet().stream().filter(entry -> (Integer)entry.getValue() >= 0).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        @Generated
        public Map<String, Integer> getExtractableClasses() {
            return this.extractableClasses;
        }
    }

    public static class Endpoint {
        @Nullable
        private Actuator actuator;

        @Nullable
        @Generated
        public Actuator getActuator() {
            return this.actuator;
        }

        @Generated
        public void setActuator(@Nullable Actuator actuator) {
            this.actuator = actuator;
        }

        private static class Actuator {
            private boolean enabled = false;

            private Actuator() {
            }

            @Generated
            public boolean isEnabled() {
                return this.enabled;
            }

            @Generated
            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }
    }

    public static class Scanner {
        @Nullable
        private static AsyncListener asyncListener;
        @Nullable
        private static AsyncPublisher asyncPublisher;

        public static class AsyncPublisher {
            private boolean enabled = true;

            @Generated
            public boolean isEnabled() {
                return this.enabled;
            }

            @Generated
            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }

        public static class AsyncListener {
            private boolean enabled = true;

            @Generated
            public boolean isEnabled() {
                return this.enabled;
            }

            @Generated
            public void setEnabled(boolean enabled) {
                this.enabled = enabled;
            }
        }
    }
}

