/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.springwolf.asyncapi.v3.model.components.ComponentSchema;
import io.github.springwolf.asyncapi.v3.model.schema.SchemaObject;
import io.github.springwolf.core.asyncapi.components.ComponentsService;
import io.github.springwolf.core.controller.dtos.MessageDto;
import jakarta.annotation.Nullable;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublishingPayloadCreator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PublishingPayloadCreator.class);
    private final ComponentsService componentsService;
    private final ObjectMapper objectMapper;

    public Result createPayloadObject(MessageDto message) {
        String messagePayloadType = message.getPayloadType();
        if ("".equals(message.getPayload())) {
            return new Result(null, Optional.empty());
        }
        Map<String, ComponentSchema> knownSchemas = this.componentsService.getSchemas();
        Set<String> knownSchemaNames = knownSchemas.keySet();
        for (Map.Entry<String, ComponentSchema> schemaEntry : knownSchemas.entrySet()) {
            String schemaName = schemaEntry.getKey();
            ComponentSchema componentSchema = schemaEntry.getValue();
            SchemaObject schema = componentSchema.getSchema();
            if (schemaName == null || !schemaName.equals(messagePayloadType)) continue;
            try {
                Object payload = this.resolveActualPayload(message, schema, schemaName);
                return new Result(payload, Optional.empty());
            }
            catch (JsonProcessingException | ClassNotFoundException | IllegalArgumentException ex) {
                String errorMessage = MessageFormat.format("Unable to create payload {0} from data: {1}", schemaName, message.getPayload());
                log.info(errorMessage, ex);
                return new Result(null, Optional.of(errorMessage));
            }
        }
        String errorMessage = MessageFormat.format("Specified payloadType {0} is not a registered springwolf schema.", messagePayloadType);
        String knownPayloadsMessage = MessageFormat.format(" Known payloadTypes: [{0}]", StringUtils.join(knownSchemaNames, (String)", "));
        log.info("{}{}", (Object)errorMessage, (Object)knownPayloadsMessage);
        return new Result(null, Optional.of(errorMessage));
    }

    private Object resolveActualPayload(MessageDto message, SchemaObject schema, String schemaName) throws ClassNotFoundException, JsonProcessingException, IllegalArgumentException {
        switch (schema.getType()) {
            case "boolean": {
                return this.objectMapper.readValue(message.getPayload(), Boolean.class);
            }
            case "integer": {
                return this.objectMapper.readValue(message.getPayload(), Long.class);
            }
            case "number": {
                return this.objectMapper.readValue(message.getPayload(), Double.class);
            }
            case "object": {
                Class<?> payloadClass = Class.forName(schemaName);
                return this.objectMapper.readValue(message.getPayload(), payloadClass);
            }
            case "string": {
                return this.objectMapper.readValue(message.getPayload(), String.class);
            }
        }
        throw new IllegalArgumentException("Unsupported schema type: " + schema.getType());
    }

    @Generated
    public PublishingPayloadCreator(ComponentsService componentsService, ObjectMapper objectMapper) {
        this.componentsService = componentsService;
        this.objectMapper = objectMapper;
    }

    public record Result(@Nullable Object payload, Optional<String> errorMessage) {
    }
}

