/*
 * Decompiled with CFR 0.152.
 */
package io.github.springwolf.core.controller;

import io.github.springwolf.core.asyncapi.grouping.AsyncApiGroupService;
import io.github.springwolf.core.configuration.properties.SpringwolfConfigProperties;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UiConfigController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UiConfigController.class);
    private final AsyncApiGroupService asyncApiGroupService;
    private final SpringwolfConfigProperties configProperties;

    @GetMapping(path={"${springwolf.path.base:/springwolf}/ui-config"}, produces={"application/json"})
    public UiConfig getUiConfig() {
        UiConfig.InitialConfig initial = this.createInitialConfig();
        List<UiConfig.UiConfigGroup> groups = this.createGroups();
        return new UiConfig(initial, groups);
    }

    private List<UiConfig.UiConfigGroup> createGroups() {
        return this.asyncApiGroupService.getAsyncApiGroups().map(el -> new UiConfig.UiConfigGroup(el.getGroupName())).toList();
    }

    private UiConfig.InitialConfig createInitialConfig() {
        SpringwolfConfigProperties.UI.Defaults defaults = this.configProperties.getUi().getDefaults();
        return new UiConfig.InitialConfig(defaults.isShowBindings(), defaults.isShowHeaders());
    }

    @Generated
    public UiConfigController(AsyncApiGroupService asyncApiGroupService, SpringwolfConfigProperties configProperties) {
        this.asyncApiGroupService = asyncApiGroupService;
        this.configProperties = configProperties;
    }

    private record UiConfig(InitialConfig initialConfig, List<UiConfigGroup> groups) {

        private record InitialConfig(boolean showBindings, boolean showHeaders) {
        }

        private record UiConfigGroup(String name) {
        }
    }
}

