/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.cli;

import io.gitlab.arturbosch.detekt.api.CompositeConfig;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.YamlConfig;
import io.gitlab.arturbosch.detekt.api.internal.PathFilters;
import io.gitlab.arturbosch.detekt.cli.ClasspathResourceConverter;
import io.gitlab.arturbosch.detekt.cli.CliArgs;
import io.gitlab.arturbosch.detekt.cli.ConfigurationsKt;
import io.gitlab.arturbosch.detekt.cli.FailFastConfig;
import io.gitlab.arturbosch.detekt.cli.MultipleClasspathResourceConverter;
import io.gitlab.arturbosch.detekt.cli.MultipleExistingPathConverter;
import java.net.URL;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b*\u00020\t\u001a\f\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\t\u001a\u0010\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b*\u00020\t\u001a9\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000f0\b\"\u0004\b\u0000\u0010\u000f*\u0004\u0018\u00010\u00012\u001d\u0010\u0010\u001a\u0019\u0012\u0004\u0012\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\b0\u0011\u00a2\u0006\u0002\b\u0012H\u0002\u001a\n\u0010\u0013\u001a\u00020\u0003*\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"DEFAULT_CONFIG", "", "loadDefaultConfig", "Lio/gitlab/arturbosch/detekt/api/Config;", "parsePathConfig", "configPath", "parseResourceConfig", "createClasspath", "", "Lio/gitlab/arturbosch/detekt/cli/CliArgs;", "createFilters", "Lio/gitlab/arturbosch/detekt/api/internal/PathFilters;", "createPlugins", "Ljava/nio/file/Path;", "letIfNonEmpty", "T", "init", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "loadConfiguration", "detekt-cli"})
public final class ConfigurationsKt {
    @NotNull
    public static final String DEFAULT_CONFIG = "default-detekt-config.yml";

    @Nullable
    public static final PathFilters createFilters(@NotNull CliArgs $this$createFilters) {
        Intrinsics.checkParameterIsNotNull((Object)$this$createFilters, (String)"$this$createFilters");
        return PathFilters.Companion.of($this$createFilters.getIncludes(), $this$createFilters.getExcludes());
    }

    @NotNull
    public static final List<Path> createPlugins(@NotNull CliArgs $this$createPlugins) {
        Intrinsics.checkParameterIsNotNull((Object)$this$createPlugins, (String)"$this$createPlugins");
        return ConfigurationsKt.letIfNonEmpty($this$createPlugins.getPlugins(), createPlugins.1.INSTANCE);
    }

    @NotNull
    public static final List<String> createClasspath(@NotNull CliArgs $this$createClasspath) {
        Intrinsics.checkParameterIsNotNull((Object)$this$createClasspath, (String)"$this$createClasspath");
        return ConfigurationsKt.letIfNonEmpty($this$createClasspath.getClasspath(), createClasspath.1.INSTANCE);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final <T> List<T> letIfNonEmpty(@Nullable String $this$letIfNonEmpty, Function1<? super String, ? extends List<? extends T>> init) {
        List list;
        if ($this$letIfNonEmpty != null) {
            CharSequence charSequence = $this$letIfNonEmpty;
            boolean bl = false;
            if (!(charSequence.length() == 0)) {
                list = (List)init.invoke((Object)$this$letIfNonEmpty);
                return list;
            }
        }
        boolean bl = false;
        list = CollectionsKt.emptyList();
        return list;
    }

    @NotNull
    public static final Config loadConfiguration(@NotNull CliArgs $this$loadConfiguration) {
        Config config;
        Config config2;
        Intrinsics.checkParameterIsNotNull((Object)$this$loadConfiguration, (String)"$this$loadConfiguration");
        CharSequence charSequence = $this$loadConfiguration.getConfig();
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            String string = $this$loadConfiguration.getConfig();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            config2 = ConfigurationsKt.parsePathConfig(string);
        } else {
            charSequence = $this$loadConfiguration.getConfigResource();
            bl = false;
            bl2 = false;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                String string = $this$loadConfiguration.getConfigResource();
                if (string == null) {
                    Intrinsics.throwNpe();
                }
                config2 = ConfigurationsKt.parseResourceConfig(string);
            } else {
                config2 = null;
            }
        }
        Config declaredConfig = config2;
        Config defaultConfig = null;
        if ($this$loadConfiguration.getBuildUponDefaultConfig()) {
            defaultConfig = ConfigurationsKt.loadDefaultConfig();
            Config config3 = declaredConfig;
            if (config3 == null) {
                config3 = defaultConfig;
            }
            declaredConfig = (Config)new CompositeConfig(config3, defaultConfig);
        }
        if ($this$loadConfiguration.getFailFast()) {
            Config config4;
            Config initializedDefaultConfig;
            Config config5 = defaultConfig;
            if (config5 == null) {
                config5 = initializedDefaultConfig = ConfigurationsKt.loadDefaultConfig();
            }
            if ((config4 = declaredConfig) == null) {
                config4 = initializedDefaultConfig;
            }
            declaredConfig = new FailFastConfig(config4, initializedDefaultConfig);
        }
        if ($this$loadConfiguration.getDebug()) {
            String string = "" + '\n' + declaredConfig + '\n';
            bl2 = false;
            System.out.println((Object)string);
        }
        if ((config = declaredConfig) == null) {
            config = ConfigurationsKt.loadDefaultConfig();
        }
        return config;
    }

    /*
     * WARNING - void declaration
     */
    private static final Config parseResourceConfig(String configPath) {
        Config config;
        Object urls = new MultipleClasspathResourceConverter().convert(configPath);
        if (urls.size() == 1) {
            config = YamlConfig.Companion.loadResource((URL)urls.get(0));
        } else {
            Sequence $this$reduce$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)urls)), (Function1)parseResourceConfig.1.INSTANCE);
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty sequence can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void config2;
                Config config3 = (Config)iterator$iv.next();
                Config composite = (Config)accumulator$iv;
                boolean bl = false;
                accumulator$iv = new CompositeConfig((Config)config2, composite);
            }
            config = (Config)accumulator$iv;
        }
        return config;
    }

    /*
     * WARNING - void declaration
     */
    private static final Config parsePathConfig(String configPath) {
        Config config;
        Object paths = new MultipleExistingPathConverter().convert(configPath);
        if (paths.size() == 1) {
            config = YamlConfig.Companion.load((Path)paths.get(0));
        } else {
            Sequence $this$reduce$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)paths)), (Function1)parsePathConfig.1.INSTANCE);
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw (Throwable)new UnsupportedOperationException("Empty sequence can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void config2;
                Config config3 = (Config)iterator$iv.next();
                Config composite = (Config)accumulator$iv;
                boolean bl = false;
                accumulator$iv = new CompositeConfig((Config)config2, composite);
            }
            config = (Config)accumulator$iv;
        }
        return config;
    }

    private static final Config loadDefaultConfig() {
        return YamlConfig.Companion.loadResource(new ClasspathResourceConverter().convert(DEFAULT_CONFIG));
    }
}

