/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.EditorConfig;
import com.pinterest.ktlint.core.KtLint;
import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.ruleset.standard.PackageKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtTypeConstraintList;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002Je\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2K\u0010\u000b\u001aG\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u00060\fH\u0016J\f\u0010\u0013\u001a\u00020\u0004*\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/IndentationRule;", "Lcom/pinterest/ktlint/core/Rule;", "()V", "indentSize", "", "visit", "", "node", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "autoCorrect", "", "emit", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "previousIndentSize", "ktlint-ruleset-standard"})
public final class IndentationRule
extends Rule {
    private int indentSize = -1;

    @Override
    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        if (com.pinterest.ktlint.core.ast.PackageKt.isRoot(node)) {
            Object object = node.getUserData(KtLint.INSTANCE.getEDITOR_CONFIG_USER_DATA_KEY());
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"node.getUserData(KtLint.\u2026R_CONFIG_USER_DATA_KEY)!!");
            EditorConfig editorConfig = (EditorConfig)object;
            this.indentSize = editorConfig.getIndentSize();
            return;
        }
        if (this.indentSize <= 1) {
            return;
        }
        if (node instanceof PsiWhiteSpace && !com.pinterest.ktlint.core.ast.PackageKt.isPartOf(node, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(PsiComment.class))) {
            String string = node.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.getText()");
            List lines = StringsKt.split$default((CharSequence)string, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
            if (lines.size() > 1 && !com.pinterest.ktlint.core.ast.PackageKt.isPartOf(node, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(KtTypeConstraintList.class))) {
                int offset = node.getStartOffset() + ((String)CollectionsKt.first((List)lines)).length() + 1;
                int previousIndentSize = this.previousIndentSize(node);
                Iterable $this$forEach$iv = PackageKt.tail(lines);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String indent2 = (String)element$iv;
                    boolean bl = false;
                    CharSequence charSequence = indent2;
                    boolean bl2 = false;
                    if (charSequence.length() > 0 && (indent2.length() - previousIndentSize) % this.indentSize != 0 && !com.pinterest.ktlint.core.ast.PackageKt.isPartOf(node, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(KtParameterList.class))) {
                        emit.invoke((Object)offset, (Object)("Unexpected indentation (" + indent2.length() + ") (it should be " + (previousIndentSize + this.indentSize) + ')'), (Object)false);
                    }
                    offset += indent2.length() + 1;
                }
            }
            if (node.textContains('\t')) {
                String string2 = node.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"node.getText()");
                String text = string2;
                emit.invoke((Object)(node.getStartOffset() + StringsKt.indexOf$default((CharSequence)text, (char)'\t', (int)0, (boolean)false, (int)6, null)), (Object)"Unexpected Tab character(s)", (Object)true);
                if (autoCorrect) {
                    ((LeafPsiElement)node).rawReplaceWithText(StringsKt.replace$default((String)text, (String)"\t", (String)StringsKt.repeat((CharSequence)" ", (int)this.indentSize), (boolean)false, (int)4, null));
                }
            }
        }
    }

    private final int previousIndentSize(@NotNull ASTNode $this$previousIndentSize) {
        ASTNode node = $this$previousIndentSize.getTreeParent();
        while (node != null) {
            ASTNode aSTNode;
            IElementType nextNode;
            ASTNode aSTNode2 = node.getTreeNext();
            Object object = nextNode = aSTNode2 != null ? aSTNode2.getElementType() : null;
            if (node instanceof PsiWhiteSpace && Intrinsics.areEqual((Object)nextNode, (Object)ElementType.INSTANCE.getTYPE_REFERENCE()) ^ true && Intrinsics.areEqual((Object)nextNode, (Object)ElementType.INSTANCE.getSUPER_TYPE_LIST()) ^ true && Intrinsics.areEqual((Object)nextNode, (Object)ElementType.INSTANCE.getCONSTRUCTOR_DELEGATION_CALL()) ^ true && node.textContains('\n')) {
                ASTNode aSTNode3 = com.pinterest.ktlint.core.ast.PackageKt.nextLeaf$default(node, false, false, 3, null);
                if (aSTNode3 == null || !com.pinterest.ktlint.core.ast.PackageKt.isPartOf(aSTNode3, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(PsiComment.class))) {
                    String string = node.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"node.getText()");
                    String text = string;
                    return text.length() - StringsKt.lastIndexOf$default((CharSequence)text, (char)'\n', (int)0, (boolean)false, (int)6, null) - 1;
                }
            }
            if ((aSTNode = node.getTreePrev()) == null) {
                aSTNode = node.getTreeParent();
            }
            node = aSTNode;
        }
        return 0;
    }

    public IndentationRule() {
        super("indent");
    }
}

