/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002Je\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00042K\u0010\u000b\u001aG\u0012\u0013\u0012\u00110\r\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0012\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0013\u0012\u0004\u0012\u00020\b0\fH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/NoSemicolonsRule;", "Lcom/pinterest/ktlint/core/Rule;", "()V", "doesNotRequirePreSemi", "", "nextLeaf", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "visit", "", "node", "autoCorrect", "emit", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "offset", "", "errorMessage", "canBeAutoCorrected", "ktlint-ruleset-standard"})
public final class NoSemicolonsRule
extends Rule {
    @Override
    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getKDOC_TEXT())) {
            return;
        }
        if (node instanceof LeafPsiElement && ((LeafPsiElement)node).textMatches((CharSequence)";") && !PackageKt.isPartOfString(node) && !PackageKt.isPartOf(node, (KClass<? extends PsiElement>)Reflection.getOrCreateKotlinClass(KtEnumEntry.class))) {
            ASTNode nextLeaf = PackageKt.nextLeaf$default(node, false, false, 3, null);
            if (this.doesNotRequirePreSemi(nextLeaf)) {
                ASTNode aSTNode = PackageKt.prevCodeLeaf$default(node, false, 1, null);
                if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getOBJECT_KEYWORD())) {
                    return;
                }
                emit.invoke((Object)((LeafPsiElement)node).getStartOffset(), (Object)"Unnecessary semicolon", (Object)true);
                if (autoCorrect) {
                    ((LeafPsiElement)node).getTreeParent().removeChild(node);
                }
            } else if (!(nextLeaf instanceof PsiWhiteSpace)) {
                ASTNode prevLeaf2 = PackageKt.prevLeaf$default(node, false, 1, null);
                if (prevLeaf2 instanceof PsiWhiteSpace && prevLeaf2.textContains('\n')) {
                    return;
                }
                emit.invoke((Object)(((LeafPsiElement)node).getStartOffset() + 1), (Object)"Missing spacing after \";\"", (Object)true);
                if (autoCorrect) {
                    PackageKt.upsertWhitespaceAfterMe((LeafElement)node, " ");
                }
            }
        }
    }

    private final boolean doesNotRequirePreSemi(ASTNode nextLeaf) {
        if (nextLeaf instanceof PsiWhiteSpace) {
            ASTNode nextNextLeaf = PackageKt.nextLeaf$default(nextLeaf, false, false, 3, null);
            return nextNextLeaf == null || nextLeaf.textContains('\n') && Intrinsics.areEqual((Object)nextNextLeaf.getText(), (Object)"{") ^ true;
        }
        return nextLeaf == null;
    }

    public NoSemicolonsRule() {
        super("no-semi");
    }
}

