/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.ruleset.standard;

import com.pinterest.ktlint.core.EditorConfig;
import com.pinterest.ktlint.core.KtLint;
import com.pinterest.ktlint.core.Rule;
import com.pinterest.ktlint.core.ast.ElementType;
import com.pinterest.ktlint.core.ast.PackageKt;
import com.pinterest.ktlint.ruleset.standard.ParameterListWrappingRule;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.PsiWhiteSpaceImpl;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0002Je\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102K\u0010\u0011\u001aG\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0015\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0013\u0012\b\b\u0014\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u000e0\u0012H\u0016J\f\u0010\u0017\u001a\u00020\u000b*\u00020\u0007H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00020\u0004*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/pinterest/ktlint/ruleset/standard/ParameterListWrappingRule;", "Lcom/pinterest/ktlint/core/Rule;", "()V", "indentSize", "", "maxLineLength", "column", "Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;", "getColumn", "(Lorg/jetbrains/kotlin/com/intellij/lang/ASTNode;)I", "errorMessage", "", "node", "visit", "", "autoCorrect", "", "emit", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "offset", "canBeAutoCorrected", "lineIndent", "ktlint-ruleset-standard"})
public final class ParameterListWrappingRule
extends Rule {
    private int indentSize = -1;
    private int maxLineLength = -1;

    /*
     * WARNING - void declaration
     */
    @Override
    public void visit(@NotNull ASTNode node, boolean autoCorrect, @NotNull Function3<? super Integer, ? super String, ? super Boolean, Unit> emit) {
        ASTNode aSTNode;
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull(emit, (String)"emit");
        if (PackageKt.isRoot(node)) {
            Object object = node.getUserData(KtLint.INSTANCE.getEDITOR_CONFIG_USER_DATA_KEY());
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"node.getUserData(KtLint.\u2026R_CONFIG_USER_DATA_KEY)!!");
            EditorConfig editorConfig = (EditorConfig)object;
            this.indentSize = editorConfig.getIndentSize();
            this.maxLineLength = editorConfig.getMaxLineLength();
            return;
        }
        if (this.indentSize <= 0) {
            return;
        }
        if (Intrinsics.areEqual((Object)node.getElementType(), (Object)ElementType.INSTANCE.getVALUE_PARAMETER_LIST()) && Intrinsics.areEqual((Object)((aSTNode = node.getFirstChildNode()) != null && (aSTNode = aSTNode.getTreeNext()) != null ? aSTNode.getElementType() : null), (Object)ElementType.INSTANCE.getRPAR()) ^ true) {
            ASTNode aSTNode2 = node.getTreeParent();
            if (Intrinsics.areEqual((Object)(aSTNode2 != null ? aSTNode2.getElementType() : null), (Object)ElementType.INSTANCE.getFUNCTION_LITERAL()) ^ true) {
                boolean putParametersOnSeparateLines;
                boolean bl = putParametersOnSeparateLines = node.textContains('\n') || this.maxLineLength > -1 && this.getColumn(node) - 1 + node.getTextLength() > this.maxLineLength;
                if (putParametersOnSeparateLines) {
                    String indent2 = "\n" + this.lineIndent(node);
                    String paramIndent = indent2 + StringsKt.repeat((CharSequence)" ", (int)this.indentSize);
                    for (ASTNode child : PackageKt.children(node)) {
                        void paramInnerIndentAdjustment;
                        String intendedIndent;
                        ASTNode prevLeaf2;
                        IElementType iElementType = child.getElementType();
                        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getLPAR())) {
                            prevLeaf2 = PackageKt.prevLeaf$default(child, false, 1, null);
                            if (!(prevLeaf2 instanceof PsiWhiteSpace) || !prevLeaf2.textContains('\n')) continue;
                            emit.invoke((Object)child.getStartOffset(), (Object)this.errorMessage(child), (Object)true);
                            if (!autoCorrect) continue;
                            ((PsiWhiteSpace)prevLeaf2).delete();
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_PARAMETER()) && !Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getRPAR())) continue;
                        prevLeaf2 = new Ref.IntRef();
                        prevLeaf2.element = 0;
                        ASTNode prevLeaf3 = PackageKt.prevLeaf$default(child, false, 1, null);
                        String string = intendedIndent = Intrinsics.areEqual((Object)child.getElementType(), (Object)ElementType.INSTANCE.getVALUE_PARAMETER()) ? paramIndent : indent2;
                        if (prevLeaf3 instanceof PsiWhiteSpace) {
                            int n;
                            String string2;
                            String spacing;
                            Intrinsics.checkExpressionValueIsNotNull((Object)prevLeaf3.getText(), (String)"prevLeaf.getText()");
                            int cut = StringsKt.lastIndexOf$default((CharSequence)spacing, (String)"\n", (int)0, (boolean)false, (int)6, null);
                            if (cut > -1) {
                                String childIndent;
                                string2 = spacing;
                                n = 0;
                                String string3 = string2;
                                if (string3 == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                }
                                Intrinsics.checkExpressionValueIsNotNull((Object)string3.substring(cut), (String)"(this as java.lang.String).substring(startIndex)");
                                if (Intrinsics.areEqual((Object)childIndent, (Object)intendedIndent)) continue;
                                emit.invoke((Object)child.getStartOffset(), (Object)("Unexpected indentation" + " (expected " + (intendedIndent.length() - 1) + ", actual " + (childIndent.length() - 1) + ')'), (Object)true);
                            } else {
                                emit.invoke((Object)child.getStartOffset(), (Object)this.errorMessage(child), (Object)true);
                            }
                            if (autoCorrect) {
                                String string4;
                                StringBuilder stringBuilder = new StringBuilder();
                                if (cut > -1) {
                                    String string5;
                                    string2 = spacing;
                                    n = 0;
                                    StringBuilder stringBuilder2 = stringBuilder;
                                    boolean bl2 = false;
                                    String string6 = string2;
                                    if (string6 == null) {
                                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                                    }
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string6.substring(n, cut), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                    stringBuilder = stringBuilder2;
                                    string4 = string5;
                                } else {
                                    string4 = "";
                                }
                                String adjustedIndent = stringBuilder.append(string4).append(intendedIndent).toString();
                                paramInnerIndentAdjustment.element = adjustedIndent.length() - prevLeaf3.getTextLength();
                                ((LeafPsiElement)prevLeaf3).rawReplaceWithText(adjustedIndent);
                            }
                        } else {
                            emit.invoke((Object)child.getStartOffset(), (Object)this.errorMessage(child), (Object)true);
                            if (autoCorrect) {
                                paramInnerIndentAdjustment.element = intendedIndent.length() - this.getColumn(child);
                                node.addChild((ASTNode)new PsiWhiteSpaceImpl((CharSequence)intendedIndent), child);
                            }
                        }
                        if (paramInnerIndentAdjustment.element == 0 || !Intrinsics.areEqual((Object)child.getElementType(), (Object)ElementType.INSTANCE.getVALUE_PARAMETER())) continue;
                        PackageKt.visit(child, (Function1<? super ASTNode, Unit>)((Function1)new Function1<ASTNode, Unit>((Ref.IntRef)paramInnerIndentAdjustment){
                            final /* synthetic */ Ref.IntRef $paramInnerIndentAdjustment;

                            public final void invoke(@NotNull ASTNode n) {
                                Intrinsics.checkParameterIsNotNull((Object)n, (String)"n");
                                if (Intrinsics.areEqual((Object)n.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) && n.textContains('\n')) {
                                    String string = n.getText();
                                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"n.text");
                                    List split = StringsKt.split$default((CharSequence)string, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
                                    ((LeafElement)n).rawReplaceWithText(CollectionsKt.joinToString$default((Iterable)split, (CharSequence)"\n", null, null, (int)0, null, (Function1)((Function1)new Function1<String, CharSequence>(this){
                                        final /* synthetic */ visit.1 this$0;

                                        @NotNull
                                        public final CharSequence invoke(@NotNull String it) {
                                            CharSequence charSequence;
                                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                            if (this.this$0.$paramInnerIndentAdjustment.element > 0) {
                                                charSequence = it + StringsKt.repeat((CharSequence)" ", (int)this.this$0.$paramInnerIndentAdjustment.element);
                                            } else {
                                                String string = it;
                                                int n = 0;
                                                int n2 = Math.max(it.length() + this.this$0.$paramInnerIndentAdjustment.element, 0);
                                                boolean bl = false;
                                                String string2 = string.substring(n, n2);
                                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                                charSequence = string2;
                                            }
                                            return charSequence;
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            super(1);
                                        }
                                    }), (int)30, null));
                                }
                            }
                            {
                                this.$paramInnerIndentAdjustment = intRef;
                                super(1);
                            }
                        }));
                    }
                }
            }
        }
    }

    private final int getColumn(@NotNull ASTNode $this$column) {
        ASTNode leaf = PackageKt.prevLeaf$default($this$column, false, 1, null);
        int offsetToTheLeft = 0;
        while (leaf != null) {
            if (Intrinsics.areEqual((Object)leaf.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) && leaf.textContains('\n')) {
                int n = leaf.getTextLength() - 1;
                String string = leaf.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"leaf.text");
                offsetToTheLeft += n - StringsKt.lastIndexOf$default((CharSequence)string, (char)'\n', (int)0, (boolean)false, (int)6, null);
                break;
            }
            offsetToTheLeft += leaf.getTextLength();
            leaf = PackageKt.prevLeaf$default(leaf, false, 1, null);
        }
        return offsetToTheLeft + 1;
    }

    private final String errorMessage(ASTNode node) {
        String string;
        IElementType iElementType = node.getElementType();
        if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getLPAR())) {
            string = "Unnecessary newline before \"(\"";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getVALUE_PARAMETER())) {
            string = "Parameter should be on a separate line (unless all parameters can fit a single line)";
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)ElementType.INSTANCE.getRPAR())) {
            string = "Missing newline before \")\"";
        } else {
            throw (Throwable)new UnsupportedOperationException();
        }
        return string;
    }

    private final String lineIndent(@NotNull ASTNode $this$lineIndent) {
        ASTNode leaf = PackageKt.prevLeaf$default($this$lineIndent, false, 1, null);
        while (leaf != null) {
            if (Intrinsics.areEqual((Object)leaf.getElementType(), (Object)ElementType.INSTANCE.getWHITE_SPACE()) && leaf.textContains('\n')) {
                String string = leaf.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"leaf.text");
                String string2 = string;
                String string3 = leaf.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"leaf.text");
                int n = StringsKt.lastIndexOf$default((CharSequence)string3, (char)'\n', (int)0, (boolean)false, (int)6, null) + 1;
                boolean bl = false;
                String string4 = string2;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n);
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                return string5;
            }
            leaf = PackageKt.prevLeaf$default(leaf, false, 1, null);
        }
        return "";
    }

    public ParameterListWrappingRule() {
        super("parameter-list-wrapping");
    }
}

