/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.empty;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.LazyRegex;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.rules.AllowedExceptionNamePatternKt;
import io.gitlab.arturbosch.detekt.rules.empty.EmptyRule;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/rules/empty/EmptyCatchBlock;", "Lio/gitlab/arturbosch/detekt/rules/empty/EmptyRule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "allowedExceptionNameRegex", "Lkotlin/text/Regex;", "getAllowedExceptionNameRegex", "()Lkotlin/text/Regex;", "allowedExceptionNameRegex$delegate", "Lio/gitlab/arturbosch/detekt/api/LazyRegex;", "visitCatchSection", "", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "Companion", "detekt-rules-empty"})
public final class EmptyCatchBlock
extends EmptyRule {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final LazyRegex allowedExceptionNameRegex$delegate;
    @NotNull
    public static final String ALLOWED_EXCEPTION_NAME_REGEX = "allowedExceptionNameRegex";
    @NotNull
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(EmptyCatchBlock.class, ALLOWED_EXCEPTION_NAME_REGEX, "getAllowedExceptionNameRegex()Lkotlin/text/Regex;", 0))};
        Companion = new Companion(null);
    }

    private final Regex getAllowedExceptionNameRegex() {
        return this.allowedExceptionNameRegex$delegate.getValue((Rule)this, $$delegatedProperties[0]);
    }

    public void visitCatchSection(@NotNull KtCatchClause catchClause) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)catchClause, (String)"catchClause");
            super.visitCatchSection(catchClause);
            if (AllowedExceptionNamePatternKt.isAllowedExceptionName((KtCatchClause)catchClause, (Regex)this.getAllowedExceptionNameRegex())) {
                return;
            }
            KtExpression ktExpression = catchClause.getCatchBody();
            if (ktExpression == null) break block1;
            this.addFindingIfBlockExprIsEmpty(ktExpression);
        }
    }

    public EmptyCatchBlock(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, "Empty catch block detected. Empty catch blocks indicate that an exception is ignored and not handled.", "Empty catch block detected. If the exception can be safely ignored, name the exception according to one of the exemptions as per the configuration of this rule.");
        this.allowedExceptionNameRegex$delegate = new LazyRegex(ALLOWED_EXCEPTION_NAME_REGEX, "_|(ignore|expected).*");
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/empty/EmptyCatchBlock$Companion;", "", "()V", "ALLOWED_EXCEPTION_NAME_REGEX", "", "detekt-rules-empty"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

