/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.CompilerResources;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u000fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/NullableToStringCall;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitSimpleNameExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "detekt-rules-errorprone"})
public final class NullableToStringCall
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression) {
        KtQualifiedExpression qualified;
        block16: {
            block17: {
                boolean bl;
                block14: {
                    Object object;
                    CallableDescriptor descriptor;
                    CompilerResources compilerResources;
                    block19: {
                        block18: {
                            block15: {
                                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                                super.visitSimpleNameExpression(expression);
                                if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
                                    return;
                                }
                                qualified = KtPsiUtilKt.getQualifiedExpressionForReceiver((KtExpression)((KtExpression)expression));
                                if (qualified == null) break block15;
                                CallableDescriptor callableDescriptor = this.descriptor((KtExpression)qualified);
                                if (Intrinsics.areEqual((Object)(callableDescriptor != null ? DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)callableDescriptor)) : null), (Object)new FqName("kotlin.toString")) ^ true) {
                                    return;
                                }
                                break block16;
                            }
                            if (!(expression.getParent() instanceof KtStringTemplateEntry)) break block17;
                            CompilerResources compilerResources2 = this.getCompilerResources();
                            if (compilerResources2 == null) {
                                return;
                            }
                            compilerResources = compilerResources2;
                            CallableDescriptor callableDescriptor = this.descriptor((KtExpression)expression);
                            if (callableDescriptor == null) {
                                return;
                            }
                            descriptor = callableDescriptor;
                            object = descriptor.getReturnType();
                            if (object == null) break block18;
                            KotlinType kotlinType = object;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            KotlinType it = kotlinType;
                            boolean bl4 = false;
                            KotlinType kotlinType2 = it;
                            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"it");
                            object = KotlinTypeKt.isNullable((KotlinType)kotlinType2) ? kotlinType : null;
                            if (object != null) break block19;
                        }
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"descriptor.returnType ?.\u2026.isNullable() } ?: return");
                    KotlinType originalType = object;
                    KotlinTypeInfo kotlinTypeInfo = (KotlinTypeInfo)this.getBindingContext().get((ReadOnlySlice)BindingContext.EXPRESSION_TYPE_INFO, (Object)expression);
                    if (kotlinTypeInfo == null || (kotlinTypeInfo = kotlinTypeInfo.getDataFlowInfo()) == null) {
                        return;
                    }
                    KotlinTypeInfo dataFlowInfo = kotlinTypeInfo;
                    DataFlowValue dataFlowValue = compilerResources.getDataFlowValueFactory().createDataFlowValue((KtExpression)expression, originalType, this.getBindingContext(), (DeclarationDescriptor)descriptor);
                    Set dataFlowTypes = dataFlowInfo.getStableTypes(dataFlowValue, compilerResources.getLanguageVersionSettings());
                    Iterable $this$any$iv = dataFlowTypes;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            KotlinType it = (KotlinType)element$iv;
                            boolean bl5 = false;
                            if (!(!KotlinTypeKt.isNullable((KotlinType)it))) continue;
                            bl = true;
                            break block14;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    return;
                }
                break block16;
            }
            return;
        }
        KtQualifiedExpression ktQualifiedExpression = qualified;
        PsiElement targetExpression = ktQualifiedExpression != null ? (PsiElement)ktQualifiedExpression : expression.getParent();
        Issue issue = this.getIssue();
        PsiElement psiElement = targetExpression;
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"targetExpression");
        CodeSmell codeSmell = new CodeSmell(issue, Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)psiElement, (int)0, (int)2, null), "This call '" + targetExpression.getText() + "' may return the string \"null\".", null, null, 24, null);
        this.report((Finding)codeSmell);
    }

    private final CallableDescriptor descriptor(KtExpression $this$descriptor) {
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$descriptor), (BindingContext)this.getBindingContext());
        return resolvedCall != null ? resolvedCall.getResultingDescriptor() : null;
    }

    public NullableToStringCall(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Defect, "This call may return the string \"null\"", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ NullableToStringCall(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public NullableToStringCall() {
        this(null, 1, null);
    }
}

