/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\u0004\u0018\u00010 *\u00020!H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/MemberNameEqualsClassName;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "classMessage", "", "ignoreOverridden", "", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "objectMessage", "getMisnamedCompanionObjectMembers", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "getMisnamedMembers", "klassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "name", "isFactoryMethod", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitClass", "", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Companion", "detekt-rules-naming"})
public final class MemberNameEqualsClassName
extends Rule {
    @NotNull
    private final Issue issue;
    private final String classMessage;
    private final String objectMessage;
    private final boolean ignoreOverridden;
    @NotNull
    public static final String IGNORE_OVERRIDDEN_FUNCTION = "ignoreOverriddenFunction";
    @NotNull
    public static final String IGNORE_OVERRIDDEN = "ignoreOverridden";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        if (!klass.isInterface()) {
            Sequence $this$forEach$iv = SequencesKt.plus(this.getMisnamedMembers((KtClassOrObject)klass, klass.getName()), this.getMisnamedCompanionObjectMembers(klass));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtNamedDeclaration it = (KtNamedDeclaration)element$iv;
                boolean bl = false;
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null), this.classMessage, null, null, 24, null));
            }
        }
        super.visitClass(klass);
    }

    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!declaration.isCompanion()) {
            Sequence<KtNamedDeclaration> $this$forEach$iv = this.getMisnamedMembers((KtClassOrObject)declaration, declaration.getName());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtNamedDeclaration it = (KtNamedDeclaration)element$iv;
                boolean bl = false;
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null), this.objectMessage, null, null, 24, null));
            }
        }
        super.visitObjectDeclaration(declaration);
    }

    private final Sequence<KtNamedDeclaration> getMisnamedMembers(KtClassOrObject klassOrObject, String name) {
        KtClassBody ktClassBody = klassOrObject.getBody();
        if (ktClassBody == null) {
            return SequencesKt.emptySequence();
        }
        KtClassBody body = ktClassBody;
        Sequence sequence = CollectionsKt.asSequence((Iterable)body.getFunctions());
        if (sequence == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.sequences.Sequence<org.jetbrains.kotlin.psi.KtNamedDeclaration>");
        }
        return SequencesKt.filter((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.plus((Sequence)sequence, (Iterable)body.getProperties()), (Function1)((Function1)new Function1<KtNamedDeclaration, Boolean>(this){
            final /* synthetic */ MemberNameEqualsClassName this$0;

            public final boolean invoke(@NotNull KtNamedDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return MemberNameEqualsClassName.access$getIgnoreOverridden$p(this.this$0) && KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)it));
            }
            {
                this.this$0 = memberNameEqualsClassName;
                super(1);
            }
        })), (Function1)((Function1)new Function1<KtNamedDeclaration, Boolean>(name){
            final /* synthetic */ String $name;

            public final boolean invoke(@NotNull KtNamedDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getName();
                return string != null && StringsKt.equals((String)string, (String)this.$name, (boolean)true);
            }
            {
                this.$name = string;
                super(1);
            }
        }));
    }

    private final Sequence<KtNamedDeclaration> getMisnamedCompanionObjectMembers(KtClass klass) {
        return SequencesKt.filterNot((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)klass.getCompanionObjects()), (Function1)((Function1)new Function1<KtObjectDeclaration, Sequence<? extends KtNamedDeclaration>>(this, klass){
            final /* synthetic */ MemberNameEqualsClassName this$0;
            final /* synthetic */ KtClass $klass;

            @NotNull
            public final Sequence<KtNamedDeclaration> invoke(@NotNull KtObjectDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return MemberNameEqualsClassName.access$getMisnamedMembers(this.this$0, (KtClassOrObject)it, this.$klass.getName());
            }
            {
                this.this$0 = memberNameEqualsClassName;
                this.$klass = ktClass;
                super(1);
            }
        })), (Function1)((Function1)new Function1<KtNamedDeclaration, Boolean>(this, klass){
            final /* synthetic */ MemberNameEqualsClassName this$0;
            final /* synthetic */ KtClass $klass;

            public final boolean invoke(@NotNull KtNamedDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it instanceof KtNamedFunction && MemberNameEqualsClassName.access$isFactoryMethod(this.this$0, (KtNamedFunction)it, this.$klass);
            }
            {
                this.this$0 = memberNameEqualsClassName;
                this.$klass = ktClass;
                super(1);
            }
        }));
    }

    private final boolean isFactoryMethod(KtNamedFunction function, KtClass klass) {
        boolean bl;
        KtTypeReference typeReference = function.getTypeReference();
        if (typeReference != null) {
            bl = Intrinsics.areEqual((Object)typeReference.getText(), (Object)klass.getName());
        } else if (!(function.getBodyExpression() instanceof KtBlockExpression)) {
            FunctionDescriptor functionDescriptor;
            FunctionDescriptor functionDescriptor2;
            DeclarationDescriptor declarationDescriptor = this.descriptor((KtDeclaration)function);
            if (!(declarationDescriptor instanceof FunctionDescriptor)) {
                declarationDescriptor = null;
            }
            bl = Intrinsics.areEqual((Object)((functionDescriptor2 = (functionDescriptor = (FunctionDescriptor)declarationDescriptor)) != null && (functionDescriptor2 = functionDescriptor2.getReturnType()) != null && (functionDescriptor2 = functionDescriptor2.getConstructor()) != null ? functionDescriptor2.getDeclarationDescriptor() : null), (Object)this.descriptor((KtDeclaration)klass));
        } else {
            bl = false;
        }
        return bl;
    }

    private final DeclarationDescriptor descriptor(KtDeclaration $this$descriptor) {
        return Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY) ? null : (DeclarationDescriptor)this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (Object)$this$descriptor);
    }

    public MemberNameEqualsClassName(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "A member should not be given the same name as its parent class or object.", Debt.Companion.getFIVE_MINS());
        this.classMessage = "A member is named after the class. This might result in confusion. Either rename the member or change it to a constructor.";
        this.objectMessage = "A member is named after the object. This might result in confusion. Please rename the member.";
        this.ignoreOverridden = (Boolean)this.valueOrDefault(IGNORE_OVERRIDDEN, this.valueOrDefault(IGNORE_OVERRIDDEN_FUNCTION, true));
    }

    public /* synthetic */ MemberNameEqualsClassName(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public MemberNameEqualsClassName() {
        this(null, 1, null);
    }

    public static final /* synthetic */ boolean access$getIgnoreOverridden$p(MemberNameEqualsClassName $this) {
        return $this.ignoreOverridden;
    }

    public static final /* synthetic */ Sequence access$getMisnamedMembers(MemberNameEqualsClassName $this, KtClassOrObject klassOrObject, String name) {
        return $this.getMisnamedMembers(klassOrObject, name);
    }

    public static final /* synthetic */ boolean access$isFactoryMethod(MemberNameEqualsClassName $this, KtNamedFunction function, KtClass klass) {
        return $this.isFactoryMethod(function, klass);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/MemberNameEqualsClassName$Companion;", "", "()V", "IGNORE_OVERRIDDEN", "", "IGNORE_OVERRIDDEN_FUNCTION", "detekt-rules-naming"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

