/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.LazyRegex;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.IdentifierNameKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.naming.util.ExcludeClassKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\n\u001a\u0004\b\u0012\u0010\b\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/FunctionParameterNaming;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "excludeClassPattern", "Lkotlin/text/Regex;", "getExcludeClassPattern", "()Lkotlin/text/Regex;", "excludeClassPattern$delegate", "Lio/gitlab/arturbosch/detekt/api/LazyRegex;", "ignoreOverridden", "", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "parameterPattern", "getParameterPattern", "parameterPattern$delegate", "visitParameter", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "Companion", "detekt-rules-naming"})
public final class FunctionParameterNaming
extends Rule {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    private final LazyRegex parameterPattern$delegate;
    private final LazyRegex excludeClassPattern$delegate;
    private final boolean ignoreOverridden;
    @NotNull
    public static final String PARAMETER_PATTERN = "parameterPattern";
    @NotNull
    public static final String EXCLUDE_CLASS_PATTERN = "excludeClassPattern";
    @NotNull
    public static final String IGNORE_OVERRIDDEN_FUNCTIONS = "ignoreOverriddenFunctions";
    @NotNull
    public static final String IGNORE_OVERRIDDEN = "ignoreOverridden";
    @NotNull
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(FunctionParameterNaming.class, PARAMETER_PATTERN, "getParameterPattern()Lkotlin/text/Regex;", 0)), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(FunctionParameterNaming.class, EXCLUDE_CLASS_PATTERN, "getExcludeClassPattern()Lkotlin/text/Regex;", 0))};
        Companion = new Companion(null);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Regex getParameterPattern() {
        return this.parameterPattern$delegate.getValue((Rule)this, $$delegatedProperties[0]);
    }

    private final Regex getExcludeClassPattern() {
        return this.excludeClassPattern$delegate.getValue((Rule)this, $$delegatedProperties[1]);
    }

    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        if (ExcludeClassKt.isContainingExcludedClass((KtDeclaration)parameter, this.getExcludeClassPattern())) {
            return;
        }
        if (this.ignoreOverridden) {
            KtDeclarationWithBody ktDeclarationWithBody = parameter.getOwnerFunction();
            if (ktDeclarationWithBody != null) {
                if (KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)ktDeclarationWithBody))) {
                    return;
                }
            }
        }
        String identifier = IdentifierNameKt.identifierName((KtNamedDeclaration)((KtNamedDeclaration)parameter));
        CharSequence charSequence = identifier;
        Regex regex = this.getParameterPattern();
        boolean bl = false;
        if (!regex.matches(charSequence)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)parameter), (int)0, (int)2, null), "Function parameter names should match the pattern: " + this.getParameterPattern(), null, null, 24, null));
        }
    }

    public FunctionParameterNaming(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Function parameter names should follow the naming convention set in the projects configuration.", Debt.Companion.getFIVE_MINS());
        this.parameterPattern$delegate = new LazyRegex(PARAMETER_PATTERN, "[a-z][A-Za-z\\d]*");
        this.excludeClassPattern$delegate = new LazyRegex(EXCLUDE_CLASS_PATTERN, "$^");
        this.ignoreOverridden = (Boolean)this.valueOrDefault(IGNORE_OVERRIDDEN, this.valueOrDefault(IGNORE_OVERRIDDEN_FUNCTIONS, true));
    }

    public /* synthetic */ FunctionParameterNaming(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public FunctionParameterNaming() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/FunctionParameterNaming$Companion;", "", "()V", "EXCLUDE_CLASS_PATTERN", "", "IGNORE_OVERRIDDEN", "IGNORE_OVERRIDDEN_FUNCTIONS", "PARAMETER_PATTERN", "detekt-rules-naming"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

