/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.LazyRegex;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.IdentifierNameKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\n\u001a\u0004\b\u0010\u0010\bR\u001b\u0010\u0012\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0013\u0010\b\u00a8\u0006\u001f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/TopLevelPropertyNaming;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "constantPattern", "Lkotlin/text/Regex;", "getConstantPattern", "()Lkotlin/text/Regex;", "constantPattern$delegate", "Lio/gitlab/arturbosch/detekt/api/LazyRegex;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "privatePropertyPattern", "getPrivatePropertyPattern", "privatePropertyPattern$delegate", "propertyPattern", "getPropertyPattern", "propertyPattern$delegate", "handleConstant", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "handleProperty", "report", "message", "", "visitProperty", "Companion", "detekt-rules-naming"})
public final class TopLevelPropertyNaming
extends Rule {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    private final LazyRegex constantPattern$delegate;
    private final LazyRegex propertyPattern$delegate;
    private final LazyRegex privatePropertyPattern$delegate;
    @NotNull
    public static final String CONSTANT_PATTERN = "constantPattern";
    @NotNull
    public static final String PROPERTY_PATTERN = "propertyPattern";
    @NotNull
    public static final String PRIVATE_PROPERTY_PATTERN = "privatePropertyPattern";
    @NotNull
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(TopLevelPropertyNaming.class, CONSTANT_PATTERN, "getConstantPattern()Lkotlin/text/Regex;", 0)), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(TopLevelPropertyNaming.class, PROPERTY_PATTERN, "getPropertyPattern()Lkotlin/text/Regex;", 0)), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(TopLevelPropertyNaming.class, PRIVATE_PROPERTY_PATTERN, "getPrivatePropertyPattern()Lkotlin/text/Regex;", 0))};
        Companion = new Companion(null);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Regex getConstantPattern() {
        return this.constantPattern$delegate.getValue((Rule)this, $$delegatedProperties[0]);
    }

    private final Regex getPropertyPattern() {
        return this.propertyPattern$delegate.getValue((Rule)this, $$delegatedProperties[1]);
    }

    private final Regex getPrivatePropertyPattern() {
        return this.privatePropertyPattern$delegate.getValue((Rule)this, $$delegatedProperties[2]);
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (KtModifierListKt.isConstant((KtModifierListOwner)((KtModifierListOwner)property))) {
            this.handleConstant(property);
        } else {
            this.handleProperty(property);
        }
    }

    private final void handleConstant(KtProperty property) {
        CharSequence charSequence = IdentifierNameKt.identifierName((KtNamedDeclaration)((KtNamedDeclaration)property));
        Regex regex = this.getConstantPattern();
        boolean bl = false;
        if (!regex.matches(charSequence)) {
            this.report(property, "Top level constant names should match the pattern: " + this.getConstantPattern());
        }
    }

    private final void handleProperty(KtProperty property) {
        if (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)property))) {
            CharSequence charSequence = IdentifierNameKt.identifierName((KtNamedDeclaration)((KtNamedDeclaration)property));
            Regex regex = this.getPrivatePropertyPattern();
            boolean bl = false;
            if (!regex.matches(charSequence)) {
                this.report(property, "Private top level property names should match the pattern: " + this.getPrivatePropertyPattern());
            }
        } else {
            CharSequence charSequence = IdentifierNameKt.identifierName((KtNamedDeclaration)((KtNamedDeclaration)property));
            Regex regex = this.getPropertyPattern();
            boolean bl = false;
            if (!regex.matches(charSequence)) {
                this.report(property, "Top level property names should match the pattern: " + this.getPropertyPattern());
            }
        }
    }

    private final void report(KtProperty property, String message) {
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)property), message, null, null, 24, null));
    }

    public TopLevelPropertyNaming(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Top level property names should follow the naming convention set in the projects configuration.", Debt.Companion.getFIVE_MINS());
        this.constantPattern$delegate = new LazyRegex(CONSTANT_PATTERN, "[A-Z][_A-Z0-9]*");
        this.propertyPattern$delegate = new LazyRegex(PROPERTY_PATTERN, "[A-Za-z][_A-Za-z0-9]*");
        this.privatePropertyPattern$delegate = new LazyRegex(PRIVATE_PROPERTY_PATTERN, "_?[A-Za-z][_A-Za-z0-9]*");
    }

    public /* synthetic */ TopLevelPropertyNaming(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public TopLevelPropertyNaming() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/TopLevelPropertyNaming$Companion;", "", "()V", "CONSTANT_PATTERN", "", "PRIVATE_PROPERTY_PATTERN", "PROPERTY_PATTERN", "detekt-rules-naming"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

