/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules;

import io.gitlab.arturbosch.detekt.rules.KtAnnotatedExtensionsKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\u0007\u001a\u00020\u0004*\u00020\u0005\u001a\n\u0010\b\u001a\u00020\u0004*\u00020\t\u001a\n\u0010\n\u001a\u00020\u0004*\u00020\t\u001a\n\u0010\u000b\u001a\u00020\u0004*\u00020\t\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"knownAnys", "", "", "hasCorrectEqualsParameter", "", "Lorg/jetbrains/kotlin/psi/KtFunction;", "isEqualsFunction", "isHashCodeFunction", "isMainFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isMainInsideObject", "isTopLevelMain", "detekt-rules"})
public final class MethodSignatureKt {
    private static final Set<String> knownAnys = SetsKt.setOf((Object[])new String[]{"Any?", "kotlin.Any?"});

    public static final boolean isEqualsFunction(@NotNull KtFunction $this$isEqualsFunction) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isEqualsFunction, (String)"$this$isEqualsFunction");
        return Intrinsics.areEqual((Object)$this$isEqualsFunction.getName(), (Object)"equals") && MethodSignatureKt.hasCorrectEqualsParameter($this$isEqualsFunction) && KtModifierListKt.isOverride((KtModifierListOwner)$this$isEqualsFunction);
    }

    public static final boolean isHashCodeFunction(@NotNull KtFunction $this$isHashCodeFunction) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isHashCodeFunction, (String)"$this$isHashCodeFunction");
        return Intrinsics.areEqual((Object)$this$isHashCodeFunction.getName(), (Object)"hashCode") && $this$isHashCodeFunction.getValueParameters().isEmpty() && KtModifierListKt.isOverride((KtModifierListOwner)$this$isHashCodeFunction);
    }

    public static final boolean hasCorrectEqualsParameter(@NotNull KtFunction $this$hasCorrectEqualsParameter) {
        Intrinsics.checkParameterIsNotNull((Object)$this$hasCorrectEqualsParameter, (String)"$this$hasCorrectEqualsParameter");
        Iterable iterable = knownAnys;
        List list = $this$hasCorrectEqualsParameter.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"this.valueParameters");
        KtParameter ktParameter = (KtParameter)CollectionsKt.firstOrNull((List)list);
        return CollectionsKt.contains((Iterable)iterable, ktParameter != null && (ktParameter = ktParameter.getTypeReference()) != null ? ktParameter.getText() : null);
    }

    public static final boolean isMainFunction(@NotNull KtNamedFunction $this$isMainFunction) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isMainFunction, (String)"$this$isMainFunction");
        return MethodSignatureKt.isTopLevelMain($this$isMainFunction) || MethodSignatureKt.isMainInsideObject($this$isMainFunction);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isMainInsideObject(@NotNull KtNamedFunction $this$isMainInsideObject) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isMainInsideObject, (String)"$this$isMainInsideObject");
        if (!Intrinsics.areEqual((Object)$this$isMainInsideObject.getName(), (Object)"main")) return false;
        if (!KtModifierListKt.isPublicNotOverridden((KtModifierListOwner)$this$isMainInsideObject)) return false;
        PsiElement psiElement = $this$isMainInsideObject.getParent();
        if (!((psiElement != null ? psiElement.getParent() : null) instanceof KtObjectDeclaration)) return false;
        if (!KtAnnotatedExtensionsKt.hasAnnotation((KtAnnotated)$this$isMainInsideObject, "JvmStatic", "kotlin.jvm.JvmStatic")) return false;
        return true;
    }

    public static final boolean isTopLevelMain(@NotNull KtNamedFunction $this$isTopLevelMain) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isTopLevelMain, (String)"$this$isTopLevelMain");
        return Intrinsics.areEqual((Object)$this$isTopLevelMain.getName(), (Object)"main") && KtModifierListKt.isPublicNotOverridden((KtModifierListOwner)$this$isTopLevelMain) && $this$isTopLevelMain.isTopLevel();
    }
}

