/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.MethodSignatureKt;
import io.gitlab.arturbosch.detekt.rules.bugs.EqualsAlwaysReturnsTrueOrFalse$isSingleReturnWithBooleanConstant$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\u0012\u001a\u00020\n*\u00020\u0013H\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/EqualsAlwaysReturnsTrueOrFalse;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "isReturningBooleanConstant", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isSingleReturnWithBooleanConstant", "bodyExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitNamedFunction", "", "isBooleanConstant", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "detekt-rules"})
public final class EqualsAlwaysReturnsTrueOrFalse
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        if (MethodSignatureKt.isEqualsFunction((KtFunction)function) && this.isReturningBooleanConstant(function)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)function), (int)0, (int)2, null), "This equals function always returns the same result regardless on the input parameters.", null, null, 24, null));
        }
    }

    private final boolean isReturningBooleanConstant(KtNamedFunction function) {
        KtExpression ktExpression = function.getBodyExpression();
        if (ktExpression == null) {
            return false;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"function.bodyExpression ?: return false");
        KtExpression bodyExpression = ktExpression;
        return bodyExpression instanceof KtConstantExpression ? this.isBooleanConstant((PsiElement)bodyExpression) : this.isSingleReturnWithBooleanConstant(bodyExpression);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSingleReturnWithBooleanConstant(KtExpression bodyExpression) {
        KtExpression ktExpression;
        void $this$forEachDescendantOfType$iv$iv$iv;
        PsiElement $this$getChildrenOfType$iv = (PsiElement)bodyExpression;
        boolean $i$f$getChildrenOfType = false;
        PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtReturnExpression.class);
        if (psiElementArray == null) {
            psiElementArray = new KtReturnExpression[]{};
        }
        Object[] returnExpressionsInBlock = (KtReturnExpression[])psiElementArray;
        KtExpression lastValidReturnExpression = ((KtReturnExpression)ArraysKt.first((Object[])returnExpressionsInBlock)).getReturnedExpression();
        PsiElement $this$collectDescendantsOfType$iv = (PsiElement)bodyExpression;
        Function1 predicate$iv = isSingleReturnWithBooleanConstant$$inlined$collectDescendantsOfType$1.INSTANCE;
        boolean $i$f$collectDescendantsOfType = false;
        PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        ArrayList result$iv$iv = new ArrayList();
        PsiElement psiElement = $this$collectDescendantsOfType$iv$iv;
        Function1 action$iv$iv$iv = (Function1)new Function1<KtReturnExpression, Unit>(predicate$iv, result$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ ArrayList $result;
            {
                this.$predicate = function1;
                this.$result = arrayList;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$result.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        $this$forEachDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $captured_local_variable$1;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtReturnExpression) {
                    this.$action.invoke((Object)element);
                }
            }
        });
        List allReturnExpressions = result$iv$iv;
        boolean hasNoNestedReturnExpression = allReturnExpressions.size() == returnExpressionsInBlock.length;
        KtExpression ktExpression2 = lastValidReturnExpression;
        if (ktExpression2 == null) return false;
        if (!this.isBooleanConstant((PsiElement)ktExpression2)) return false;
        if (hasNoNestedReturnExpression) return true;
        Iterable $this$all$iv = allReturnExpressions;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            KtReturnExpression it = (KtReturnExpression)element$iv;
            boolean bl = false;
            ktExpression = it.getReturnedExpression();
        } while (Intrinsics.areEqual((Object)(ktExpression != null ? ktExpression.getText() : null), (Object)lastValidReturnExpression.getText()));
        return false;
    }

    private final boolean isBooleanConstant(@NotNull PsiElement $this$isBooleanConstant) {
        ASTNode aSTNode = $this$isBooleanConstant.getNode();
        Intrinsics.checkExpressionValueIsNotNull((Object)aSTNode, (String)"node");
        return Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)KtNodeTypes.BOOLEAN_CONSTANT);
    }

    public EqualsAlwaysReturnsTrueOrFalse(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("EqualsAlwaysReturnsTrueOrFalse", Severity.Defect, "Having an equals method which always returns true or false is not a good idea. It does not follow the contract of this method. Consider a good default implementation. For example this == other", Debt.Companion.getTWENTY_MINS());
    }

    public /* synthetic */ EqualsAlwaysReturnsTrueOrFalse(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public EqualsAlwaysReturnsTrueOrFalse() {
        this(null, 1, null);
    }
}

