/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0014H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/UnreachableCode;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "followedByUnreachableCode", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitBreakExpression", "Lorg/jetbrains/kotlin/psi/KtBreakExpression;", "visitContinueExpression", "Lorg/jetbrains/kotlin/psi/KtContinueExpression;", "visitReturnExpression", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "visitThrowExpression", "Lorg/jetbrains/kotlin/psi/KtThrowExpression;", "detekt-rules"})
public final class UnreachableCode
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitReturnExpression(@NotNull KtReturnExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        this.followedByUnreachableCode((KtExpression)expression);
        super.visitReturnExpression(expression);
    }

    public void visitThrowExpression(@NotNull KtThrowExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        this.followedByUnreachableCode((KtExpression)expression);
        super.visitThrowExpression(expression);
    }

    public void visitContinueExpression(@NotNull KtContinueExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        this.followedByUnreachableCode((KtExpression)expression);
    }

    public void visitBreakExpression(@NotNull KtBreakExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        this.followedByUnreachableCode((KtExpression)expression);
    }

    private final void followedByUnreachableCode(KtExpression expression) {
        Object object;
        PsiElement psiElement = expression.getParent();
        if (!(psiElement instanceof KtBlockExpression)) {
            psiElement = null;
        }
        if ((object = (KtBlockExpression)psiElement) == null || (object = object.getStatements()) == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"(expression.parent as? K\u2026on)?.statements ?: return");
        Object statements = object;
        int indexOfStatement = statements.indexOf(expression);
        if (indexOfStatement < statements.size() - 1) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "This expression is followed by unreachable code which should either be used or removed.", null, null, 24, null));
        }
    }

    public UnreachableCode(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("UnreachableCode", Severity.Warning, "Unreachable code detected. This code should be removed", Debt.Companion.getTEN_MINS());
    }

    public /* synthetic */ UnreachableCode(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public UnreachableCode() {
        this(null, 1, null);
    }
}

