/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdRule;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.api.internal.McCabeVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/ComplexMethod;", "Lio/gitlab/arturbosch/detekt/api/ThresholdRule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "threshold", "", "(Lio/gitlab/arturbosch/detekt/api/Config;I)V", "ignoreSimpleWhenEntries", "", "ignoreSingleWhenExpression", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "hasSingleWhenExpression", "bodyExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "visitNamedFunction", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Companion", "detekt-rules"})
public final class ComplexMethod
extends ThresholdRule {
    @NotNull
    private final Issue issue;
    private final boolean ignoreSingleWhenExpression;
    private final boolean ignoreSimpleWhenEntries;
    public static final int DEFAULT_ACCEPTED_METHOD_COMPLEXITY = 10;
    @NotNull
    public static final String IGNORE_SINGLE_WHEN_EXPRESSION = "ignoreSingleWhenExpression";
    @NotNull
    public static final String IGNORE_SIMPLE_WHEN_ENTRIES = "ignoreSimpleWhenEntries";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        if (this.hasSingleWhenExpression(function.getBodyExpression())) {
            return;
        }
        McCabeVisitor visitor = new McCabeVisitor(this.ignoreSimpleWhenEntries);
        visitor.visitNamedFunction(function);
        int mcc = visitor.getMcc();
        if (mcc >= this.getThreshold()) {
            this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)function), (int)0, (int)2, null), new Metric("MCC", mcc, this.getThreshold(), false, 0, 24, null), "The function " + function.getNameAsSafeName() + " appears to be too complex.", null, 16, null));
        }
    }

    private final boolean hasSingleWhenExpression(KtExpression bodyExpression) {
        if (this.ignoreSingleWhenExpression) {
            boolean bl;
            if (bodyExpression instanceof KtBlockExpression && ((KtBlockExpression)bodyExpression).getStatements().size() == 1) {
                List list = ((KtBlockExpression)bodyExpression).getStatements();
                Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"bodyExpression.statements");
                KtExpression statement = (KtExpression)CollectionsKt.single((List)list);
                bl = statement instanceof KtWhenExpression || statement instanceof KtReturnExpression && ((KtReturnExpression)statement).getReturnedExpression() instanceof KtWhenExpression;
            } else {
                bl = bodyExpression instanceof KtWhenExpression;
            }
            return bl;
        }
        return false;
    }

    public ComplexMethod(@NotNull Config config, int threshold) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, threshold);
        this.issue = new Issue("ComplexMethod", Severity.Maintainability, "Prefer splitting up complex methods into smaller, easier to understand methods.", Debt.Companion.getTWENTY_MINS());
        this.ignoreSingleWhenExpression = (Boolean)this.valueOrDefault(IGNORE_SINGLE_WHEN_EXPRESSION, false);
        this.ignoreSimpleWhenEntries = (Boolean)this.valueOrDefault(IGNORE_SIMPLE_WHEN_ENTRIES, false);
    }

    public /* synthetic */ ComplexMethod(Config config, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        if ((n2 & 2) != 0) {
            n = 10;
        }
        this(config, n);
    }

    public ComplexMethod() {
        this(null, 0, 3, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/ComplexMethod$Companion;", "", "()V", "DEFAULT_ACCEPTED_METHOD_COMPLEXITY", "", "IGNORE_SIMPLE_WHEN_ENTRIES", "", "IGNORE_SINGLE_WHEN_EXPRESSION", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

