/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdRule;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/MethodOverloading;", "Lio/gitlab/arturbosch/detekt/api/ThresholdRule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "threshold", "", "(Lio/gitlab/arturbosch/detekt/api/Config;I)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "Companion", "OverloadedMethodVisitor", "detekt-rules"})
public final class MethodOverloading
extends ThresholdRule {
    @NotNull
    private final Issue issue;
    public static final int DEFAULT_ACCEPTED_OVERLOAD_COUNT = 6;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkParameterIsNotNull((Object)klass, (String)"klass");
        OverloadedMethodVisitor visitor = new OverloadedMethodVisitor();
        klass.accept((PsiElementVisitor)visitor);
        visitor.reportIfThresholdExceeded((PsiElement)klass);
        super.visitClass(klass);
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        OverloadedMethodVisitor visitor = new OverloadedMethodVisitor();
        PsiElement $this$getChildrenOfType$iv = (PsiElement)file;
        boolean $i$f$getChildrenOfType = false;
        PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtNamedFunction.class);
        if (psiElementArray == null) {
            psiElementArray = new KtNamedFunction[]{};
        }
        PsiElement[] $this$forEach$iv = psiElementArray;
        boolean $i$f$forEach = false;
        for (PsiElement element$iv : $this$forEach$iv) {
            KtNamedFunction it = (KtNamedFunction)element$iv;
            boolean bl = false;
            it.accept((PsiElementVisitor)visitor);
        }
        visitor.reportIfThresholdExceeded((PsiElement)file);
        super.visitKtFile(file);
    }

    public MethodOverloading(@NotNull Config config, int threshold) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, threshold);
        this.issue = new Issue("MethodOverloading", Severity.Maintainability, "Methods which are overloaded often might be harder to maintain. Furthermore, these methods are tightly coupled. Refactor these methods and try to use optional parameters.", Debt.Companion.getTWENTY_MINS());
    }

    public /* synthetic */ MethodOverloading(Config config, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        if ((n2 & 2) != 0) {
            n = 6;
        }
        this(config, n);
    }

    public MethodOverloading() {
        this(null, 0, 3, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/MethodOverloading$OverloadedMethodVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "(Lio/gitlab/arturbosch/detekt/rules/complexity/MethodOverloading;)V", "methods", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "reportIfThresholdExceeded", "", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "detekt-rules"})
    public final class OverloadedMethodVisitor
    extends DetektVisitor {
        private HashMap<String, Integer> methods = new HashMap();

        public final void reportIfThresholdExceeded(@NotNull PsiElement element) {
            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
            Map $this$filterValues$iv = this.methods;
            boolean $i$f$filterValues = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            Map map = $this$filterValues$iv;
            boolean bl = false;
            for (Map.Entry entry$iv : map.entrySet()) {
                int it = ((Number)entry$iv.getValue()).intValue();
                boolean bl2 = false;
                if (!(it >= MethodOverloading.this.getThreshold())) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            Map $this$forEach$iv = result$iv;
            boolean $i$f$forEach = false;
            Map map2 = $this$forEach$iv;
            boolean bl3 = false;
            Iterator iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl4 = false;
                MethodOverloading.this.report((Finding)new ThresholdedCodeSmell(MethodOverloading.this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)element, (int)0, (int)2, null), new Metric("OVERLOAD SIZE: ", ((Number)it.getValue()).intValue(), MethodOverloading.this.getThreshold(), false, 0, 24, null), "The method '" + (String)it.getKey() + "' is overloaded " + ((Number)it.getValue()).intValue() + " times.", null, 16, null));
            }
        }

        public void visitNamedFunction(@NotNull KtNamedFunction function) {
            Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
            String string = function.getName();
            if (string == null) {
                return;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"function.name ?: return");
            String name = string;
            KtTypeReference receiver = function.getReceiverTypeReference();
            if (KtPsiUtilKt.isExtensionDeclaration((PsiElement)((PsiElement)function)) && receiver != null) {
                name = receiver.getText() + '.' + name;
            }
            ((Map)this.methods).put(name, ((Number)this.methods.getOrDefault(name, 0)).intValue() + 1);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/MethodOverloading$Companion;", "", "()V", "DEFAULT_ACCEPTED_OVERLOAD_COUNT", "", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

