/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.rules.KtAnnotatedExtensionsKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/TooManyFunctions;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "amountOfTopLevelFunctions", "", "ignoreDeprecated", "", "ignoreOverridden", "ignorePrivate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "thresholdInClasses", "thresholdInEnums", "thresholdInFiles", "thresholdInInterfaces", "thresholdInObjects", "calcFunctions", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "isIgnoredFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitNamedFunction", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "Companion", "detekt-rules"})
public final class TooManyFunctions
extends Rule {
    @NotNull
    private final Issue issue;
    private final int thresholdInFiles;
    private final int thresholdInClasses;
    private final int thresholdInObjects;
    private final int thresholdInInterfaces;
    private final int thresholdInEnums;
    private final boolean ignoreDeprecated;
    private final boolean ignorePrivate;
    private final boolean ignoreOverridden;
    private int amountOfTopLevelFunctions;
    public static final int DEFAULT_THRESHOLD = 11;
    @NotNull
    public static final String THRESHOLD_IN_FILES = "thresholdInFiles";
    @NotNull
    public static final String THRESHOLD_IN_CLASSES = "thresholdInClasses";
    @NotNull
    public static final String THRESHOLD_IN_INTERFACES = "thresholdInInterfaces";
    @NotNull
    public static final String THRESHOLD_IN_OBJECTS = "thresholdInObjects";
    @NotNull
    public static final String THRESHOLD_IN_ENUMS = "thresholdInEnums";
    @NotNull
    public static final String IGNORE_DEPRECATED = "ignoreDeprecated";
    @NotNull
    public static final String IGNORE_PRIVATE = "ignorePrivate";
    @NotNull
    public static final String IGNORE_OVERRIDDEN = "ignoreOverridden";
    private static final String DEPRECATED = "Deprecated";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        super.visitKtFile(file);
        if (this.amountOfTopLevelFunctions >= this.thresholdInFiles) {
            this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)file), (int)0, (int)2, null), new Metric("SIZE", this.amountOfTopLevelFunctions, this.thresholdInFiles, false, 0, 24, null), "File '" + file.getName() + "' with '" + this.amountOfTopLevelFunctions + "' functions detected. " + "Defined threshold inside files is set to '" + this.thresholdInFiles + '\'', null, 16, null));
        }
        this.amountOfTopLevelFunctions = 0;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        if (function.isTopLevel() && !this.isIgnoredFunction(function)) {
            int n = this.amountOfTopLevelFunctions;
            this.amountOfTopLevelFunctions = n + 1;
        }
    }

    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkParameterIsNotNull((Object)klass, (String)"klass");
        int amount = this.calcFunctions((KtClassOrObject)klass);
        if (klass.isInterface()) {
            if (amount >= this.thresholdInInterfaces) {
                this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)klass), (int)0, (int)2, null), new Metric("SIZE", amount, this.thresholdInInterfaces, false, 0, 24, null), "Interface '" + klass.getName() + "' with '" + amount + "' functions detected. " + "Defined threshold inside interfaces is set to " + '\'' + this.thresholdInInterfaces + '\'', null, 16, null));
            }
        } else if (klass.isEnum()) {
            if (amount >= this.thresholdInEnums) {
                this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)klass), (int)0, (int)2, null), new Metric("SIZE", amount, this.thresholdInEnums, false, 0, 24, null), "Enum class '" + klass.getName() + "' with '" + amount + "' functions detected. " + "Defined threshold inside enum classes is set to " + '\'' + this.thresholdInEnums + '\'', null, 16, null));
            }
        } else if (amount >= this.thresholdInClasses) {
            this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)klass), (int)0, (int)2, null), new Metric("SIZE", amount, this.thresholdInClasses, false, 0, 24, null), "Class '" + klass.getName() + "' with '" + amount + "' functions detected. " + "Defined threshold inside classes is set to '" + this.thresholdInClasses + '\'', null, 16, null));
        }
        super.visitClass(klass);
    }

    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        int amount = this.calcFunctions((KtClassOrObject)declaration);
        if (amount >= this.thresholdInObjects) {
            this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)declaration), (int)0, (int)2, null), new Metric("SIZE", amount, this.thresholdInObjects, false, 0, 24, null), "Object '" + declaration.getName() + "' with '" + amount + "' functions detected. " + "Defined threshold inside objects is set to '" + this.thresholdInObjects + '\'', null, 16, null));
        }
        super.visitObjectDeclaration(declaration);
    }

    /*
     * WARNING - void declaration
     */
    private final int calcFunctions(KtClassOrObject classOrObject) {
        int n;
        Object object = classOrObject.getBody();
        if (object != null && (object = object.getDeclarations()) != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = (Iterable)object;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtNamedFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtNamedFunction it = (KtNamedFunction)element$iv$iv;
                boolean bl = false;
                if (!(!this.isIgnoredFunction(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            n = ((List)destination$iv$iv).size();
        } else {
            n = 0;
        }
        return n;
    }

    private final boolean isIgnoredFunction(KtNamedFunction function) {
        return this.ignoreDeprecated && KtAnnotatedExtensionsKt.hasAnnotation((KtAnnotated)function, DEPRECATED) ? true : (this.ignorePrivate && KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)function)) ? true : this.ignoreOverridden && KtModifierListKt.isOverride((KtModifierListOwner)function));
    }

    public TooManyFunctions(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("TooManyFunctions", Severity.Maintainability, "Too many functions inside a/an file/class/object/interface always indicate a violation of the single responsibility principle. Maybe the file/class/object/interface wants to manage too many things at once. Extract functionality which clearly belongs together.", Debt.Companion.getTWENTY_MINS());
        this.thresholdInFiles = ((Number)this.valueOrDefault(THRESHOLD_IN_FILES, 11)).intValue();
        this.thresholdInClasses = ((Number)this.valueOrDefault(THRESHOLD_IN_CLASSES, 11)).intValue();
        this.thresholdInObjects = ((Number)this.valueOrDefault(THRESHOLD_IN_OBJECTS, 11)).intValue();
        this.thresholdInInterfaces = ((Number)this.valueOrDefault(THRESHOLD_IN_INTERFACES, 11)).intValue();
        this.thresholdInEnums = ((Number)this.valueOrDefault(THRESHOLD_IN_ENUMS, 11)).intValue();
        this.ignoreDeprecated = (Boolean)this.valueOrDefault(IGNORE_DEPRECATED, false);
        this.ignorePrivate = (Boolean)this.valueOrDefault(IGNORE_PRIVATE, false);
        this.ignoreOverridden = (Boolean)this.valueOrDefault(IGNORE_OVERRIDDEN, false);
    }

    public /* synthetic */ TooManyFunctions(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public TooManyFunctions() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/TooManyFunctions$Companion;", "", "()V", "DEFAULT_THRESHOLD", "", "DEPRECATED", "", "IGNORE_DEPRECATED", "IGNORE_OVERRIDDEN", "IGNORE_PRIVATE", "THRESHOLD_IN_CLASSES", "THRESHOLD_IN_ENUMS", "THRESHOLD_IN_FILES", "THRESHOLD_IN_INTERFACES", "THRESHOLD_IN_OBJECTS", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

