/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.exceptions;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.LazyRegex;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SplitPattern;
import io.gitlab.arturbosch.detekt.rules.AllowedExceptionNamePatternKt;
import io.gitlab.arturbosch.detekt.rules.exceptions.SwallowedException$isExceptionSwallowed$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtThrowExpression;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00122\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/SwallowedException;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "allowedExceptionNameRegex", "Lkotlin/text/Regex;", "getAllowedExceptionNameRegex", "()Lkotlin/text/Regex;", "allowedExceptionNameRegex$delegate", "Lio/gitlab/arturbosch/detekt/api/LazyRegex;", "ignoredExceptionTypes", "Lio/gitlab/arturbosch/detekt/api/SplitPattern;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "callsMemberOfCaughtException", "", "expression", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "hasParameterReferences", "parameterNameReferences", "", "isExceptionSwallowed", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "isExceptionSwallowedOrUnused", "isExceptionUnused", "visitCatchSection", "", "Companion", "detekt-rules"})
public final class SwallowedException
extends Rule {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    private final SplitPattern ignoredExceptionTypes;
    private final LazyRegex allowedExceptionNameRegex$delegate;
    @NotNull
    public static final String IGNORED_EXCEPTION_TYPES = "ignoredExceptionTypes";
    @NotNull
    public static final String ALLOWED_EXCEPTION_NAME_REGEX = "allowedExceptionNameRegex";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(SwallowedException.class), ALLOWED_EXCEPTION_NAME_REGEX, "getAllowedExceptionNameRegex()Lkotlin/text/Regex;"))};
        Companion = new Companion(null);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Regex getAllowedExceptionNameRegex() {
        return this.allowedExceptionNameRegex$delegate.getValue((Rule)this, $$delegatedProperties[0]);
    }

    public void visitCatchSection(@NotNull KtCatchClause catchClause) {
        String exceptionType;
        Intrinsics.checkParameterIsNotNull((Object)catchClause, (String)"catchClause");
        KtParameter ktParameter = catchClause.getCatchParameter();
        String string = ktParameter != null && (ktParameter = ktParameter.getTypeReference()) != null ? ktParameter.getText() : (exceptionType = null);
        if (!this.ignoredExceptionTypes.contains(exceptionType) && this.isExceptionSwallowedOrUnused(catchClause) && !AllowedExceptionNamePatternKt.isAllowedExceptionName(catchClause, this.getAllowedExceptionNameRegex())) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)catchClause), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    private final boolean isExceptionSwallowedOrUnused(KtCatchClause catchClause) {
        return this.isExceptionUnused(catchClause) || this.isExceptionSwallowed(catchClause);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isExceptionUnused(KtCatchClause catchClause) {
        void result$iv$iv$iv;
        void $this$anyDescendantOfType$iv;
        KtParameter ktParameter = catchClause.getCatchParameter();
        String parameterName = ktParameter != null ? ktParameter.getName() : null;
        KtExpression ktExpression = catchClause.getCatchBody();
        if (ktExpression == null) {
            return true;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"catchClause.catchBody ?: return true");
        KtExpression catchBody = ktExpression;
        PsiElement psiElement = (PsiElement)catchBody;
        Function1 predicate$iv = (Function1)new Function1<KtNameReferenceExpression, Boolean>(parameterName){
            final /* synthetic */ String $parameterName;

            public final boolean invoke(@NotNull KtNameReferenceExpression it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return Intrinsics.areEqual((Object)it.getText(), (Object)this.$parameterName);
            }
            {
                this.$parameterName = string;
                super(1);
            }
        };
        boolean $i$f$anyDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv = $this$anyDescendantOfType$iv;
        boolean $i$f$findDescendantOfType = false;
        void $this$findDescendantOfType$iv$iv$iv = $this$findDescendantOfType$iv$iv;
        boolean $i$f$findDescendantOfType2 = false;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        $this$findDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(predicate$iv, (Ref.ObjectRef)result$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Ref.ObjectRef $result;
            {
                this.$predicate = $captured_local_variable$0;
                this.$result = $captured_local_variable$1;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                if (element instanceof KtNameReferenceExpression && ((Boolean)this.$predicate.invoke((Object)element)).booleanValue()) {
                    this.$result.element = element;
                    this.stopWalking();
                    return;
                }
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
            }
        });
        return !((PsiElement)result$iv$iv$iv.element != null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isExceptionSwallowed(KtCatchClause catchClause) {
        KtParameter ktParameter = catchClause.getCatchParameter();
        String parameterName = ktParameter != null ? ktParameter.getName() : null;
        KtExpression ktExpression = catchClause.getCatchBody();
        if (ktExpression != null) {
            PsiElement $this$forEachDescendantOfType$iv$iv$iv;
            PsiElement $this$collectDescendantsOfType$iv = (PsiElement)ktExpression;
            Function1 predicate$iv = isExceptionSwallowed$$inlined$collectDescendantsOfType$1.INSTANCE;
            boolean $i$f$collectDescendantsOfType = false;
            PsiElement $this$collectDescendantsOfType$iv$iv = $this$collectDescendantsOfType$iv;
            boolean $i$f$collectDescendantsOfType2 = false;
            ArrayList result$iv$iv = new ArrayList();
            PsiElement psiElement = $this$collectDescendantsOfType$iv$iv;
            Function1 action$iv$iv$iv = (Function1)new Function1<KtThrowExpression, Unit>(predicate$iv, result$iv$iv){
                final /* synthetic */ Function1 $predicate;
                final /* synthetic */ ArrayList $result;
                {
                    this.$predicate = function1;
                    this.$result = arrayList;
                    super(1);
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final void invoke(@NotNull PsiElement it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                        this.$result.add(it);
                    }
                }
            };
            boolean $i$f$forEachDescendantOfType = false;
            $this$forEachDescendantOfType$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv){
                final /* synthetic */ Function1 $action;
                {
                    this.$action = $captured_local_variable$1;
                }

                public void visitElement(@NotNull PsiElement element) {
                    Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                    PsiElement it = element;
                    boolean bl = false;
                    super.visitElement(element);
                    if (element instanceof KtThrowExpression) {
                        this.$action.invoke((Object)element);
                    }
                }
            });
            Iterable $this$forEach$iv = result$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            if (iterator.hasNext()) {
                List list;
                Object element$iv = iterator.next();
                KtThrowExpression throwExpr = (KtThrowExpression)element$iv;
                boolean bl = false;
                KtExpression ktExpression2 = throwExpr.getThrownExpression();
                if (ktExpression2 != null) {
                    void $this$forEachDescendantOfType$iv$iv$iv2;
                    void $this$collectDescendantsOfType$iv2;
                    $this$forEachDescendantOfType$iv$iv$iv = (PsiElement)ktExpression2;
                    Function1 predicate$iv2 = (Function1)new Function1<KtNameReferenceExpression, Boolean>(this, parameterName){
                        final /* synthetic */ SwallowedException this$0;
                        final /* synthetic */ String $parameterName$inlined;
                        {
                            this.this$0 = swallowedException;
                            this.$parameterName$inlined = string;
                            super(1);
                        }

                        public final boolean invoke(@NotNull KtNameReferenceExpression it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return Intrinsics.areEqual((Object)it.getText(), (Object)this.$parameterName$inlined);
                        }
                    };
                    boolean $i$f$collectDescendantsOfType3 = false;
                    void $this$collectDescendantsOfType$iv$iv2 = $this$collectDescendantsOfType$iv2;
                    boolean $i$f$collectDescendantsOfType4 = false;
                    ArrayList result$iv$iv2 = new ArrayList();
                    void var15_19 = $this$collectDescendantsOfType$iv$iv2;
                    Function1 action$iv$iv$iv2 = (Function1)new Function1<KtNameReferenceExpression, Unit>(predicate$iv2, result$iv$iv2){
                        final /* synthetic */ Function1 $predicate;
                        final /* synthetic */ ArrayList $result;
                        {
                            this.$predicate = function1;
                            this.$result = arrayList;
                            super(1);
                        }

                        /*
                         * Ignored method signature, as it can't be verified against descriptor
                         */
                        public final void invoke(@NotNull PsiElement it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                                this.$result.add(it);
                            }
                        }
                    };
                    boolean $i$f$forEachDescendantOfType2 = false;
                    $this$forEachDescendantOfType$iv$iv$iv2.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv2){
                        final /* synthetic */ Function1 $action;
                        {
                            this.$action = $captured_local_variable$1;
                        }

                        public void visitElement(@NotNull PsiElement element) {
                            Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                            PsiElement it = element;
                            boolean bl = false;
                            super.visitElement(element);
                            if (element instanceof KtNameReferenceExpression) {
                                this.$action.invoke((Object)element);
                            }
                        }
                    });
                    list = result$iv$iv2;
                } else {
                    list = null;
                }
                List parameterNameReferences = list;
                return this.hasParameterReferences(parameterNameReferences);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasParameterReferences(List<KtNameReferenceExpression> parameterNameReferences) {
        KtNameReferenceExpression it;
        if (parameterNameReferences == null) return false;
        Collection collection = parameterNameReferences;
        boolean bl = false;
        if (collection.isEmpty()) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Iterable $this$all$iv = parameterNameReferences;
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (KtNameReferenceExpression)element$iv;
            boolean bl3 = false;
        } while (this.callsMemberOfCaughtException(it));
        return false;
    }

    private final boolean callsMemberOfCaughtException(KtNameReferenceExpression expression) {
        PsiElement psiElement = expression.getNextSibling();
        return Intrinsics.areEqual((Object)(psiElement != null ? psiElement.getText() : null), (Object)".");
    }

    public SwallowedException(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("SwallowedException", Severity.CodeSmell, "The caught exception is swallowed. The original exception could be lost.", Debt.Companion.getTWENTY_MINS());
        this.ignoredExceptionTypes = new SplitPattern((String)this.valueOrDefault(IGNORED_EXCEPTION_TYPES, ""), null, false, 6, null);
        this.allowedExceptionNameRegex$delegate = new LazyRegex(ALLOWED_EXCEPTION_NAME_REGEX, "^(_|(ignore|expected).*)");
    }

    public /* synthetic */ SwallowedException(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public SwallowedException() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/SwallowedException$Companion;", "", "()V", "ALLOWED_EXCEPTION_NAME_REGEX", "", "IGNORED_EXCEPTION_TYPES", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

