/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.exceptions;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.LazyRegex;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.AllowedExceptionNamePatternKt;
import io.gitlab.arturbosch.detekt.rules.exceptions.TooGenericExceptionCaughtKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/TooGenericExceptionCaught;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "allowedExceptionNameRegex", "Lkotlin/text/Regex;", "getAllowedExceptionNameRegex", "()Lkotlin/text/Regex;", "allowedExceptionNameRegex$delegate", "Lio/gitlab/arturbosch/detekt/api/LazyRegex;", "exceptions", "", "", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "isTooGenericException", "", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "visitCatchSection", "", "catchClause", "Lorg/jetbrains/kotlin/psi/KtCatchClause;", "Companion", "detekt-rules"})
public final class TooGenericExceptionCaught
extends Rule {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    private final Set<String> exceptions;
    private final LazyRegex allowedExceptionNameRegex$delegate;
    @NotNull
    public static final String CAUGHT_EXCEPTIONS_PROPERTY = "exceptionNames";
    @NotNull
    public static final String ALLOWED_EXCEPTION_NAME_REGEX = "allowedExceptionNameRegex";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(TooGenericExceptionCaught.class), ALLOWED_EXCEPTION_NAME_REGEX, "getAllowedExceptionNameRegex()Lkotlin/text/Regex;"))};
        Companion = new Companion(null);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Regex getAllowedExceptionNameRegex() {
        return this.allowedExceptionNameRegex$delegate.getValue((Rule)this, $$delegatedProperties[0]);
    }

    public void visitCatchSection(@NotNull KtCatchClause catchClause) {
        Intrinsics.checkParameterIsNotNull((Object)catchClause, (String)"catchClause");
        KtParameter ktParameter = catchClause.getCatchParameter();
        if (ktParameter != null) {
            KtParameter ktParameter2 = ktParameter;
            boolean bl = false;
            boolean bl2 = false;
            KtParameter it = ktParameter2;
            boolean bl3 = false;
            KtParameter ktParameter3 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter3, (String)"it");
            if (this.isTooGenericException(ktParameter3.getTypeReference()) && !AllowedExceptionNamePatternKt.isAllowedExceptionName(catchClause, this.getAllowedExceptionNameRegex())) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
            }
        }
        super.visitCatchSection(catchClause);
    }

    private final boolean isTooGenericException(KtTypeReference typeReference) {
        KtTypeReference ktTypeReference = typeReference;
        return CollectionsKt.contains((Iterable)this.exceptions, (Object)(ktTypeReference != null ? ktTypeReference.getText() : null));
    }

    public TooGenericExceptionCaught(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Defect, "Caught exception is too generic. Prefer catching specific exceptions to the case that is currently handled.", Debt.Companion.getTWENTY_MINS());
        this.exceptions = CollectionsKt.toHashSet((Iterable)((Iterable)this.valueOrDefault(CAUGHT_EXCEPTIONS_PROPERTY, TooGenericExceptionCaughtKt.getCaughtExceptionDefaults())));
        this.allowedExceptionNameRegex$delegate = new LazyRegex(ALLOWED_EXCEPTION_NAME_REGEX, "^(_|(ignore|expected).*)");
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/exceptions/TooGenericExceptionCaught$Companion;", "", "()V", "ALLOWED_EXCEPTION_NAME_REGEX", "", "CAUGHT_EXCEPTIONS_PROPERTY", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

