/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.LazyRegex;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.IdentifierNameKt;
import io.gitlab.arturbosch.detekt.rules.naming.util.ExcludeClassKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\n\u001a\u0004\b\u0010\u0010\bR\u001b\u0010\u0012\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\n\u001a\u0004\b\u0013\u0010\b\u00a8\u0006\u001a"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/ConstructorParameterNaming;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "excludeClassPattern", "Lkotlin/text/Regex;", "getExcludeClassPattern", "()Lkotlin/text/Regex;", "excludeClassPattern$delegate", "Lio/gitlab/arturbosch/detekt/api/LazyRegex;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "parameterPattern", "getParameterPattern", "parameterPattern$delegate", "privateParameterPattern", "getPrivateParameterPattern", "privateParameterPattern$delegate", "visitParameter", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "Companion", "detekt-rules"})
public final class ConstructorParameterNaming
extends Rule {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    private final LazyRegex parameterPattern$delegate;
    private final LazyRegex privateParameterPattern$delegate;
    private final LazyRegex excludeClassPattern$delegate;
    @NotNull
    public static final String PARAMETER_PATTERN = "parameterPattern";
    @NotNull
    public static final String PRIVATE_PARAMETER_PATTERN = "privateParameterPattern";
    @NotNull
    public static final String EXCLUDE_CLASS_PATTERN = "excludeClassPattern";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ConstructorParameterNaming.class), PARAMETER_PATTERN, "getParameterPattern()Lkotlin/text/Regex;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ConstructorParameterNaming.class), PRIVATE_PARAMETER_PATTERN, "getPrivateParameterPattern()Lkotlin/text/Regex;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ConstructorParameterNaming.class), EXCLUDE_CLASS_PATTERN, "getExcludeClassPattern()Lkotlin/text/Regex;"))};
        Companion = new Companion(null);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Regex getParameterPattern() {
        return this.parameterPattern$delegate.getValue((Rule)this, $$delegatedProperties[0]);
    }

    private final Regex getPrivateParameterPattern() {
        return this.privateParameterPattern$delegate.getValue((Rule)this, $$delegatedProperties[1]);
    }

    private final Regex getExcludeClassPattern() {
        return this.excludeClassPattern$delegate.getValue((Rule)this, $$delegatedProperties[2]);
    }

    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        if (ExcludeClassKt.isContainingExcludedClassOrObject((KtDeclaration)parameter, this.getExcludeClassPattern())) {
            return;
        }
        String identifier = IdentifierNameKt.identifierName((KtNamedDeclaration)parameter);
        if (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)parameter))) {
            CharSequence charSequence = identifier;
            Regex regex = this.getPrivateParameterPattern();
            boolean bl = false;
            if (!regex.matches(charSequence)) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)parameter), (int)0, (int)2, null), "Constructor private parameter names should " + "match the pattern: " + this.getPrivateParameterPattern(), null, null, 24, null));
            }
        } else {
            CharSequence charSequence = identifier;
            Regex regex = this.getParameterPattern();
            boolean bl = false;
            if (!regex.matches(charSequence)) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)parameter), (int)0, (int)2, null), "Constructor parameter names should match the pattern: " + this.getParameterPattern(), null, null, 24, null));
            }
        }
    }

    public ConstructorParameterNaming(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Constructor parameter names should follow the naming convention set in the projects configuration.", Debt.Companion.getFIVE_MINS());
        this.parameterPattern$delegate = new LazyRegex(PARAMETER_PATTERN, "[a-z][A-Za-z\\d]*");
        this.privateParameterPattern$delegate = new LazyRegex(PRIVATE_PARAMETER_PATTERN, "[a-z][A-Za-z\\d]*");
        this.excludeClassPattern$delegate = new LazyRegex(EXCLUDE_CLASS_PATTERN, "$^");
    }

    public /* synthetic */ ConstructorParameterNaming(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public ConstructorParameterNaming() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/ConstructorParameterNaming$Companion;", "", "()V", "EXCLUDE_CLASS_PATTERN", "", "PARAMETER_PATTERN", "PRIVATE_PARAMETER_PATTERN", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

