/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.naming.MemberNameEqualsClassName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.util.collectionUtils.ScopeUtilsKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/MemberNameEqualsClassName;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "classMessage", "", "ignoreOverriddenFunction", "", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "objectMessage", "getFunctions", "", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "body", "Lorg/jetbrains/kotlin/psi/KtClassBody;", "getMisnamedCompanionObjectMembers", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "getMisnamedMembers", "klassOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "name", "isFactoryMethod", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitClass", "", "visitObjectDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "Companion", "detekt-rules"})
public final class MemberNameEqualsClassName
extends Rule {
    @NotNull
    private final Issue issue;
    private final String classMessage;
    private final String objectMessage;
    private final boolean ignoreOverriddenFunction;
    @NotNull
    public static final String IGNORE_OVERRIDDEN_FUNCTION = "ignoreOverriddenFunction";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkParameterIsNotNull((Object)klass, (String)"klass");
        if (!klass.isInterface()) {
            Collection collection = ScopeUtilsKt.concat((Collection)this.getMisnamedMembers((KtClassOrObject)klass, klass.getName()), (Collection)this.getMisnamedCompanionObjectMembers(klass));
            if (collection != null) {
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtNamedDeclaration it = (KtNamedDeclaration)element$iv;
                    boolean bl = false;
                    this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null), this.classMessage, null, null, 24, null));
                }
            }
        }
        super.visitClass(klass);
    }

    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        if (!declaration.isCompanion()) {
            Iterable $this$forEach$iv = this.getMisnamedMembers((KtClassOrObject)declaration, declaration.getName());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtNamedDeclaration it = (KtNamedDeclaration)element$iv;
                boolean bl = false;
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)it), (int)0, (int)2, null), this.objectMessage, null, null, 24, null));
            }
        }
        super.visitObjectDeclaration(declaration);
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtNamedDeclaration> getMisnamedMembers(KtClassOrObject klassOrObject, String name) {
        List list;
        Collection declarations;
        KtClassBody ktClassBody = klassOrObject.getBody();
        if (ktClassBody == null) {
            return CollectionsKt.emptyList();
        }
        KtClassBody body = ktClassBody;
        Collection collection = declarations = ScopeUtilsKt.concat((Collection)this.getFunctions(body), (Collection)body.getProperties());
        if (collection != null) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                KtNamedDeclaration it = (KtNamedDeclaration)element$iv$iv;
                boolean bl = false;
                String string = it.getName();
                if (!(string != null && StringsKt.equals((String)string, (String)name, (boolean)true))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        List list2 = list;
        boolean bl = false;
        List list3 = list2;
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        return list3;
    }

    private final List<KtNamedDeclaration> getFunctions(KtClassBody body) {
        PsiElement $this$getChildrenOfType$iv = (PsiElement)body;
        boolean $i$f$getChildrenOfType = false;
        Object[] objectArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtNamedFunction.class);
        if (objectArray == null) {
            objectArray = new KtNamedFunction[]{};
        }
        List functions = ArraysKt.toMutableList((Object[])objectArray);
        if (this.ignoreOverriddenFunction) {
            CollectionsKt.removeAll((List)functions, (Function1)getFunctions.1.INSTANCE);
        }
        return functions;
    }

    /*
     * WARNING - void declaration
     */
    private final List<KtNamedDeclaration> getMisnamedCompanionObjectMembers(KtClass klass) {
        void $this$filterNotTo$iv$iv;
        KtObjectDeclaration it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = klass.getCompanionObjects();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (KtObjectDeclaration)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.getMisnamedMembers((KtClassOrObject)it, klass.getName());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$flatMapTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (KtNamedDeclaration)element$iv$iv;
            boolean bl = false;
            if (it instanceof KtNamedFunction && this.isFactoryMethod((KtNamedFunction)it, klass)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isFactoryMethod(KtNamedFunction function, KtClass klass) {
        KtTypeReference typeReference = function.getTypeReference();
        if (typeReference == null) {
            if (!(function.getBodyExpression() instanceof KtBlockExpression)) return true;
        }
        KtTypeReference ktTypeReference = typeReference;
        Object object = ktTypeReference;
        if (ktTypeReference == null) return false;
        String string = object.getText();
        object = string;
        if (string == null) return false;
        if (!((String)object).equals(klass.getName())) return false;
        return true;
    }

    public MemberNameEqualsClassName(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "A member should not be given the same name as its parent class or object.", Debt.Companion.getFIVE_MINS());
        this.classMessage = "A member is named after the class. This might result in confusion. Either rename the member or change it to a constructor.";
        this.objectMessage = "A member is named after the object. This might result in confusion. Please rename the member.";
        this.ignoreOverriddenFunction = (Boolean)this.valueOrDefault(IGNORE_OVERRIDDEN_FUNCTION, true);
    }

    public /* synthetic */ MemberNameEqualsClassName(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public MemberNameEqualsClassName() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/MemberNameEqualsClassName$Companion;", "", "()V", "IGNORE_OVERRIDDEN_FUNCTION", "", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

