/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.performance;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0002R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lio/gitlab/arturbosch/detekt/rules/performance/SpreadOperator;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitValueArgumentList", "", "list", "Lorg/jetbrains/kotlin/psi/KtValueArgumentList;", "canSkipArrayCopyForSpreadArgument", "", "Lorg/jetbrains/kotlin/psi/KtValueArgument;", "detekt-rules"})
public final class SpreadOperator
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitValueArgumentList(@NotNull KtValueArgumentList list) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)list, (String)"list");
        super.visitValueArgumentList(list);
        List list2 = list.getArguments();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"list.arguments");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtValueArgument it = (KtValueArgument)element$iv$iv;
            boolean bl = false;
            KtValueArgument ktValueArgument = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktValueArgument, (String)"it");
            if (!ktValueArgument.isSpread()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtValueArgument it = (KtValueArgument)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)list), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
                return;
            }
            if (this.canSkipArrayCopyForSpreadArgument(it)) continue;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)list), (int)0, (int)2, null), "Used in this way a spread operator causes a full copy of the array to be created before calling a method which has a very high performance penalty.", null, null, 24, null));
        }
    }

    private final boolean canSkipArrayCopyForSpreadArgument(@NotNull KtValueArgument $this$canSkipArrayCopyForSpreadArgument) {
        ResolvedCall resolvedCall = CallUtilKt.getResolvedCall((KtElement)((KtElement)$this$canSkipArrayCopyForSpreadArgument.getArgumentExpression()), (BindingContext)this.getBindingContext());
        if (resolvedCall == null) {
            return false;
        }
        ResolvedCall resolvedCall2 = resolvedCall;
        CallableDescriptor calleeDescriptor = resolvedCall2.getResultingDescriptor();
        return calleeDescriptor instanceof ConstructorDescriptor || CompileTimeConstantUtils.isArrayFunctionCall((ResolvedCall)resolvedCall2) || Intrinsics.areEqual((Object)DescriptorUtils.getFqName((DeclarationDescriptor)((DeclarationDescriptor)calleeDescriptor)).asString(), (Object)"kotlin.arrayOfNulls");
    }

    public SpreadOperator(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("SpreadOperator", Severity.Performance, "In most cases using a spread operator causes a full copy of the array to be created before calling a method which has a very high performance penalty.", Debt.Companion.getTWENTY_MINS());
    }

    public /* synthetic */ SpreadOperator(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public SpreadOperator() {
        this(null, 1, null);
    }
}

