/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.MultiRule;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.rules.style.KtFileContent;
import io.gitlab.arturbosch.detekt.rules.style.MaxLineLength;
import io.gitlab.arturbosch.detekt.rules.style.NoTabs;
import io.gitlab.arturbosch.detekt.rules.style.TrailingWhitespace;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/FileParsingRule;", "Lio/gitlab/arturbosch/detekt/api/MultiRule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "getConfig", "()Lio/gitlab/arturbosch/detekt/api/Config;", "maxLineLength", "Lio/gitlab/arturbosch/detekt/rules/style/MaxLineLength;", "noTabs", "Lio/gitlab/arturbosch/detekt/rules/style/NoTabs;", "rules", "", "Lio/gitlab/arturbosch/detekt/api/Rule;", "getRules", "()Ljava/util/List;", "trailingWhitespace", "Lio/gitlab/arturbosch/detekt/rules/style/TrailingWhitespace;", "visitKtFile", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "detekt-rules"})
public final class FileParsingRule
extends MultiRule {
    private final MaxLineLength maxLineLength;
    private final TrailingWhitespace trailingWhitespace;
    private final NoTabs noTabs;
    @NotNull
    private final List<Rule> rules;
    @NotNull
    private final Config config;

    @NotNull
    public List<Rule> getRules() {
        return this.rules;
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        String string = file.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.text");
        Sequence lines = StringsKt.splitToSequence$default((CharSequence)string, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
        KtFileContent fileContents = new KtFileContent(file, (Sequence<String>)lines);
        this.runIfActive(this.maxLineLength, (Function1)new Function1<MaxLineLength, Unit>(fileContents){
            final /* synthetic */ KtFileContent $fileContents;

            public final void invoke(@NotNull MaxLineLength $this$runIfActive) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$this$runIfActive), (String)"$receiver");
                $this$runIfActive.visit(this.$fileContents);
            }
            {
                this.$fileContents = ktFileContent;
                super(1);
            }
        });
        this.runIfActive(this.trailingWhitespace, (Function1)new Function1<TrailingWhitespace, Unit>(fileContents){
            final /* synthetic */ KtFileContent $fileContents;

            public final void invoke(@NotNull TrailingWhitespace $this$runIfActive) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$this$runIfActive), (String)"$receiver");
                $this$runIfActive.visit(this.$fileContents);
            }
            {
                this.$fileContents = ktFileContent;
                super(1);
            }
        });
        this.runIfActive(this.noTabs, (Function1)new Function1<NoTabs, Unit>(file){
            final /* synthetic */ KtFile $file;

            public final void invoke(@NotNull NoTabs $this$runIfActive) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)$this$runIfActive), (String)"$receiver");
                $this$runIfActive.findTabs(this.$file);
            }
            {
                this.$file = ktFile;
                super(1);
            }
        });
    }

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    public FileParsingRule(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.config = config;
        this.maxLineLength = new MaxLineLength(this.config);
        this.trailingWhitespace = new TrailingWhitespace(this.config);
        this.noTabs = new NoTabs(this.config);
        this.rules = CollectionsKt.listOf((Object[])new Rule[]{this.maxLineLength, this.trailingWhitespace, this.noTabs});
    }

    public /* synthetic */ FileParsingRule(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public FileParsingRule() {
        this(null, 1, null);
    }
}

