/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.StringExtensionsKt;
import io.gitlab.arturbosch.detekt.rules.style.JunkKt;
import io.gitlab.arturbosch.detekt.rules.style.KtFileContent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MaxLineLength;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "excludeCommentStatements", "", "excludeImportStatements", "excludePackageStatements", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "maxLineLength", "", "containsIgnoredCommentStatement", "line", "", "containsIgnoredImportStatement", "containsIgnoredPackageStatement", "isIgnoredStatement", "isValidLine", "visit", "", "element", "Lio/gitlab/arturbosch/detekt/rules/style/KtFileContent;", "Companion", "detekt-rules"})
public final class MaxLineLength
extends Rule {
    @NotNull
    private final Issue issue;
    private final int maxLineLength;
    private final boolean excludePackageStatements;
    private final boolean excludeImportStatements;
    private final boolean excludeCommentStatements;
    @NotNull
    public static final String MAX_LINE_LENGTH = "maxLineLength";
    public static final int DEFAULT_IDEA_LINE_LENGTH = 120;
    @NotNull
    public static final String EXCLUDE_PACKAGE_STATEMENTS = "excludePackageStatements";
    @NotNull
    public static final String EXCLUDE_IMPORT_STATEMENTS = "excludeImportStatements";
    @NotNull
    public static final String EXCLUDE_COMMENT_STATEMENTS = "excludeCommentStatements";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public final void visit(@NotNull KtFileContent element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        int offset = 0;
        Sequence<String> lines = element.getContent();
        KtFile file = element.getFile();
        for (String line : lines) {
            offset += line.length();
            if (!this.isValidLine(line)) {
                PsiElement ktElement = JunkKt.findFirstKtElementInParents(file, offset, line);
                if (ktElement != null) {
                    this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)ktElement, (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
                } else {
                    this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from((PsiElement)file, offset), this.getIssue().getDescription(), null, null, 24, null));
                }
            }
            ++offset;
        }
    }

    private final boolean isValidLine(String line) {
        boolean isUrl = StringExtensionsKt.lastArgumentMatchesUrl(line);
        return line.length() <= this.maxLineLength || this.isIgnoredStatement(line) || isUrl;
    }

    private final boolean isIgnoredStatement(String line) {
        return this.containsIgnoredPackageStatement(line) || this.containsIgnoredImportStatement(line) || this.containsIgnoredCommentStatement(line);
    }

    private final boolean containsIgnoredPackageStatement(String line) {
        if (!this.excludePackageStatements) {
            return false;
        }
        String string = line;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)string2)).toString(), (String)"package ", (boolean)false, (int)2, null);
    }

    private final boolean containsIgnoredImportStatement(String line) {
        if (!this.excludeImportStatements) {
            return false;
        }
        String string = line;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)string2)).toString(), (String)"import ", (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containsIgnoredCommentStatement(String line) {
        if (!this.excludeCommentStatements) {
            return false;
        }
        String string = line;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        if (StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)string2)).toString(), (String)"//", (boolean)false, (int)2, null)) return true;
        string = line;
        bl = false;
        String string3 = string;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        if (StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)string3)).toString(), (String)"/*", (boolean)false, (int)2, null)) return true;
        string = line;
        bl = false;
        String string4 = string;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        if (!StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)string4)).toString(), (String)"*", (boolean)false, (int)2, null)) return false;
        return true;
    }

    public MaxLineLength(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Line detected that is longer than the defined maximum line length in the code style.", Debt.Companion.getFIVE_MINS());
        this.maxLineLength = ((Number)this.valueOrDefault(MAX_LINE_LENGTH, 120)).intValue();
        this.excludePackageStatements = (Boolean)this.valueOrDefault(EXCLUDE_PACKAGE_STATEMENTS, true);
        this.excludeImportStatements = (Boolean)this.valueOrDefault(EXCLUDE_IMPORT_STATEMENTS, true);
        this.excludeCommentStatements = (Boolean)this.valueOrDefault(EXCLUDE_COMMENT_STATEMENTS, false);
    }

    public /* synthetic */ MaxLineLength(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public MaxLineLength() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/MaxLineLength$Companion;", "", "()V", "DEFAULT_IDEA_LINE_LENGTH", "", "EXCLUDE_COMMENT_STATEMENTS", "", "EXCLUDE_IMPORT_STATEMENTS", "EXCLUDE_PACKAGE_STATEMENTS", "MAX_LINE_LENGTH", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

