/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.JunkKt;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0012\u0010\r\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/OptionalWhenBraces;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "hasOneStatement", "", "blockExpression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "hasOptionalBrace", "visitWhenExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "detekt-rules"})
public final class OptionalWhenBraces
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitWhenExpression(@NotNull KtWhenExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        Iterator iterator = expression.getEntries().iterator();
        while (iterator.hasNext()) {
            KtBlockExpression blockExpression;
            KtWhenEntry entry;
            KtWhenEntry ktWhenEntry = entry = (KtWhenEntry)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktWhenEntry, (String)"entry");
            KtExpression ktExpression = ktWhenEntry.getExpression();
            if (!(ktExpression instanceof KtBlockExpression)) {
                ktExpression = null;
            }
            if (!this.hasOneStatement(blockExpression = (KtBlockExpression)ktExpression) || !this.hasOptionalBrace(blockExpression)) continue;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)entry), (int)0, (int)2, null), this.getIssue().getDescription(), null, null, 24, null));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasOneStatement(KtBlockExpression blockExpression) {
        KtBlockExpression ktBlockExpression = blockExpression;
        Object object = ktBlockExpression;
        if (ktBlockExpression == null) return false;
        List list = object.getStatements();
        object = list;
        if (list == null) return false;
        if (object.size() != 1) return false;
        if (JunkKt.hasCommentInside((PsiElement)blockExpression)) return false;
        return true;
    }

    private final boolean hasOptionalBrace(KtBlockExpression blockExpression) {
        return blockExpression != null && blockExpression.getLBrace() != null && blockExpression.getRBrace() != null;
    }

    public OptionalWhenBraces(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Optional braces in when expression", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ OptionalWhenBraces(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public OptionalWhenBraces() {
        this(null, 1, null);
    }
}

