/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.SplitPattern;
import io.gitlab.arturbosch.detekt.rules.style.ReturnCount;
import io.gitlab.arturbosch.detekt.rules.style.ReturnCount$isNamedReturnFromLambda$;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\f\u0010\u0017\u001a\u00020\u0006*\u00020\u0018H\u0002J\f\u0010\u0019\u001a\u00020\u0006*\u00020\u0018H\u0002J\f\u0010\u001a\u001a\u00020\u0006*\u00020\u0018H\u0002J\f\u0010\u001b\u001a\u00020\u0006*\u00020\u0018H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ReturnCount;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "excludeGuardClauses", "", "excludeLabeled", "excludeLambdas", "excludedFunctions", "Lio/gitlab/arturbosch/detekt/api/SplitPattern;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "max", "", "countFunctionReturns", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isIgnoredFunction", "visitNamedFunction", "", "isElvisOperatorGuardClause", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "isGuardClause", "isIfConditionGuardClause", "isNamedReturnFromLambda", "Companion", "detekt-rules"})
public final class ReturnCount
extends Rule {
    @NotNull
    private final Issue issue;
    private final int max;
    private final SplitPattern excludedFunctions;
    private final boolean excludeLabeled;
    private final boolean excludeLambdas;
    private final boolean excludeGuardClauses;
    @NotNull
    public static final String MAX = "max";
    @NotNull
    public static final String EXCLUDED_FUNCTIONS = "excludedFunctions";
    @NotNull
    public static final String EXCLUDE_LABELED = "excludeLabeled";
    @NotNull
    public static final String EXCLUDE_RETURN_FROM_LAMBDA = "excludeReturnFromLambda";
    @NotNull
    public static final String EXCLUDE_GUARD_CLAUSES = "excludeGuardClauses";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        int numberOfReturns;
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        super.visitNamedFunction(function);
        if (!this.isIgnoredFunction(function) && (numberOfReturns = this.countFunctionReturns(function)) > this.max) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)function), (int)0, (int)2, null), "Function " + function.getName() + " has " + numberOfReturns + " return statements which exceeds the limit of " + this.max + '.', null, null, 24, null));
        }
    }

    private final boolean isIgnoredFunction(KtNamedFunction function) {
        return this.excludedFunctions.contains(function.getName());
    }

    /*
     * WARNING - void declaration
     */
    private final int countFunctionReturns(KtNamedFunction function) {
        void returnsNumber;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = 0;
        function.accept((PsiElementVisitor)new DetektVisitor(this, (Ref.IntRef)returnsNumber){
            final /* synthetic */ ReturnCount this$0;
            final /* synthetic */ Ref.IntRef $returnsNumber;

            /*
             * WARNING - void declaration
             */
            public void visitKtElement(@NotNull KtElement element) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                if (element instanceof KtReturnExpression) {
                    boolean breakRecursion;
                    boolean bl = ReturnCount.access$getExcludeLabeled$p(this.this$0) && ((KtReturnExpression)element).getLabeledExpression() != null ? true : (ReturnCount.access$getExcludeLambdas$p(this.this$0) && ReturnCount.access$isNamedReturnFromLambda(this.this$0, (KtReturnExpression)element) ? true : (breakRecursion = ReturnCount.access$getExcludeGuardClauses$p(this.this$0) && ReturnCount.access$isGuardClause(this.this$0, (KtReturnExpression)element)));
                    if (breakRecursion) {
                        return;
                    }
                    int n = this.$returnsNumber.element;
                    this.$returnsNumber.element = n + 1;
                }
                PsiElement[] psiElementArray = element.getChildren();
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray, (String)"element.children");
                PsiElement[] $this$filter$iv = psiElementArray;
                boolean $i$f$filter = false;
                PsiElement[] psiElementArray2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                void var7_9 = $this$filterTo$iv$iv;
                int n = ((void)var7_9).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = var7_9[i];
                    boolean bl = false;
                    if (!(!(it instanceof KtNamedFunction))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    PsiElement it = (PsiElement)element$iv;
                    boolean bl = false;
                    it.accept((PsiElementVisitor)this);
                }
            }
            {
                this.this$0 = $outer;
                this.$returnsNumber = $captured_local_variable$1;
            }
        });
        return returnsNumber.element;
    }

    private final boolean isNamedReturnFromLambda(@NotNull KtReturnExpression $this$isNamedReturnFromLambda) {
        PsiElement label = $this$isNamedReturnFromLambda.getLabeledExpression();
        if (label != null) {
            boolean bl;
            block3: {
                KtElement $this$parentsOfTypeUntil$iv = (KtElement)$this$isNamedReturnFromLambda;
                boolean strict$iv = true;
                boolean $i$f$parentsOfTypeUntil = false;
                Sequence $this$filterIsInstance$iv = SequencesKt.map((Sequence)SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super KtCallExpression>, Continuation<? super Unit>, Object>($this$parentsOfTypeUntil$iv, strict$iv, null){
                    private SequenceScope p$;
                    Object L$0;
                    Object L$1;
                    int label;
                    final /* synthetic */ KtElement $this_parentsOfTypeUntil;
                    final /* synthetic */ boolean $strict;
                    {
                        this.$this_parentsOfTypeUntil = ktElement;
                        this.$strict = bl;
                        super(2, continuation);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                $this$sequence = this.p$;
                                v0 = current = this.$strict != false ? this.$this_parentsOfTypeUntil.getParent() : (PsiElement)this.$this_parentsOfTypeUntil;
lbl7:
                                // 2 sources

                                while (current != null && !(current instanceof KtNamedFunction)) {
                                    if (current instanceof KtCallExpression) {
                                        this.L$0 = $this$sequence;
                                        this.L$1 = current;
                                        this.label = 1;
                                        v1 = $this$sequence.yield((Object)current, (Continuation)this);
                                        if (v1 == var2_2) {
                                            var5_5 = var2_2;
                                            return var5_5;
                                        }
                                    }
                                    ** GOTO lbl23
                                }
                                break;
                            }
                            case 1: {
                                current = (PsiElement)this.L$1;
                                $this$sequence = (SequenceScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl23:
                                // 2 sources

                                current = current.getParent();
                                ** GOTO lbl7
                            }
                        }
                        return Unit.INSTANCE;
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                        Function2<SequenceScope<? super KtCallExpression>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        SequenceScope cfr_ignored_0 = (SequenceScope)value;
                        function2.p$ = (SequenceScope)value;
                        Function2<SequenceScope<? super KtCallExpression>, Continuation<? super Unit>, Object> function22 = function2;
                        return function22;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                })), (Function1)isNamedReturnFromLambda.1.INSTANCE);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)isNamedReturnFromLambda$$inlined$filterIsInstance$1.INSTANCE);
                if (sequence == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
                }
                Sequence $this$any$iv = SequencesKt.map((Sequence)sequence, (Function1)isNamedReturnFromLambda.2.INSTANCE);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    String string = label.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"label.text");
                    CharSequence charSequence = string;
                    String string2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it");
                    if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)string2, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            return bl;
        }
        return false;
    }

    private final boolean isGuardClause(@NotNull KtReturnExpression $this$isGuardClause) {
        return this.isIfConditionGuardClause($this$isGuardClause) || this.isElvisOperatorGuardClause($this$isGuardClause);
    }

    private final boolean isIfConditionGuardClause(@NotNull KtReturnExpression $this$isIfConditionGuardClause) {
        KtIfExpression ifConditionParent;
        PsiElement psiElement = $this$isIfConditionGuardClause.getParent();
        Object object = psiElement != null ? psiElement.getParent() : null;
        if (!(object instanceof KtIfExpression)) {
            object = null;
        }
        KtIfExpression ktIfExpression = ifConditionParent = (KtIfExpression)object;
        if (ktIfExpression != null) {
            KtIfExpression ktIfExpression2 = ktIfExpression;
            boolean bl = false;
            boolean bl2 = false;
            KtIfExpression it = ktIfExpression2;
            boolean bl3 = false;
            return KtPsiUtilKt.isFirstStatement((KtElement)((KtElement)it)) && it.getElse() == null;
        }
        return false;
    }

    private final boolean isElvisOperatorGuardClause(@NotNull KtReturnExpression $this$isElvisOperatorGuardClause) {
        KtBinaryExpression elvisGuardClauseExpression;
        PsiElement psiElement = $this$isElvisOperatorGuardClause.getParent();
        if (!(psiElement instanceof KtBinaryExpression)) {
            psiElement = null;
        }
        KtBinaryExpression ktBinaryExpression = elvisGuardClauseExpression = (KtBinaryExpression)psiElement;
        if (ktBinaryExpression != null) {
            KtElement elvisGuardClauseParent;
            KtBinaryExpression ktBinaryExpression2 = ktBinaryExpression;
            boolean bl = false;
            boolean bl2 = false;
            KtBinaryExpression it = ktBinaryExpression2;
            boolean bl3 = false;
            PsiElement psiElement2 = it.getParent();
            if (!(psiElement2 instanceof KtElement)) {
                psiElement2 = null;
            }
            KtElement ktElement = elvisGuardClauseParent = (KtElement)psiElement2;
            boolean isFirstStatement = ktElement != null ? KtPsiUtilKt.isFirstStatement((KtElement)ktElement) : false;
            return isFirstStatement && Intrinsics.areEqual((Object)it.getOperationToken(), (Object)KtTokens.ELVIS);
        }
        return false;
    }

    public ReturnCount(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Restrict the number of return statements in methods.", Debt.Companion.getTEN_MINS());
        this.max = ((Number)this.valueOrDefault(MAX, 2)).intValue();
        this.excludedFunctions = new SplitPattern((String)this.valueOrDefault(EXCLUDED_FUNCTIONS, ""), null, false, 6, null);
        this.excludeLabeled = (Boolean)this.valueOrDefault(EXCLUDE_LABELED, false);
        this.excludeLambdas = (Boolean)this.valueOrDefault(EXCLUDE_RETURN_FROM_LAMBDA, true);
        this.excludeGuardClauses = (Boolean)this.valueOrDefault(EXCLUDE_GUARD_CLAUSES, false);
    }

    public /* synthetic */ ReturnCount(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public ReturnCount() {
        this(null, 1, null);
    }

    public static final /* synthetic */ boolean access$getExcludeLabeled$p(ReturnCount $this) {
        return $this.excludeLabeled;
    }

    public static final /* synthetic */ boolean access$getExcludeLambdas$p(ReturnCount $this) {
        return $this.excludeLambdas;
    }

    public static final /* synthetic */ boolean access$isNamedReturnFromLambda(ReturnCount $this, KtReturnExpression $this$access_u24isNamedReturnFromLambda) {
        return $this.isNamedReturnFromLambda($this$access_u24isNamedReturnFromLambda);
    }

    public static final /* synthetic */ boolean access$getExcludeGuardClauses$p(ReturnCount $this) {
        return $this.excludeGuardClauses;
    }

    public static final /* synthetic */ boolean access$isGuardClause(ReturnCount $this, KtReturnExpression $this$access_u24isGuardClause) {
        return $this.isGuardClause($this$access_u24isGuardClause);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/ReturnCount$Companion;", "", "()V", "EXCLUDED_FUNCTIONS", "", "EXCLUDE_GUARD_CLAUSES", "EXCLUDE_LABELED", "EXCLUDE_RETURN_FROM_LAMBDA", "MAX", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

