/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.JunkKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/SerialVersionUIDInSerializableClass;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "versionUID", "", "hasCorrectSerialVersionUUID", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "hasLongAssignment", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "hasLongType", "isImplementingSerializable", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "isLongProperty", "visitClass", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitObjectDeclaration", "detekt-rules"})
public final class SerialVersionUIDInSerializableClass
extends Rule {
    @NotNull
    private final Issue issue;
    private final String versionUID;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitClass(@NotNull KtClass klass) {
        KtObjectDeclaration companionObject;
        Intrinsics.checkParameterIsNotNull((Object)klass, (String)"klass");
        if (!(klass.isInterface() || !this.isImplementingSerializable((KtClassOrObject)klass) || (companionObject = JunkKt.companionObject(klass)) != null && this.hasCorrectSerialVersionUUID(companionObject))) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)klass), (int)0, (int)2, null), "The class " + klass.getNameAsSafeName() + " implements" + " the Serializable interface and should thus define a serialVersionUID.", null, null, 24, null));
        }
        super.visitClass(klass);
    }

    public void visitObjectDeclaration(@NotNull KtObjectDeclaration declaration) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        if (!declaration.isCompanion() && this.isImplementingSerializable((KtClassOrObject)declaration) && !this.hasCorrectSerialVersionUUID(declaration)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)declaration), (int)0, (int)2, null), "The object " + declaration.getNameAsSafeName() + ' ' + "implements the Serializable interface and should thus define a serialVersionUID.", null, null, 24, null));
        }
        super.visitObjectDeclaration(declaration);
    }

    private final boolean isImplementingSerializable(KtClassOrObject classOrObject) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = classOrObject.getSuperTypeListEntries();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtSuperTypeListEntry it = (KtSuperTypeListEntry)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getText(), (Object)"Serializable")) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean hasCorrectSerialVersionUUID(KtObjectDeclaration declaration) {
        KtProperty ktProperty;
        Object object = declaration.getBody();
        if (object != null && (object = object.getProperties()) != null) {
            Object v1;
            block3: {
                Iterable $this$firstOrNull$iv = (Iterable)object;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KtProperty it = (KtProperty)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)this.versionUID)) continue;
                    v1 = element$iv;
                    break block3;
                }
                v1 = null;
            }
            ktProperty = v1;
        } else {
            ktProperty = null;
        }
        KtProperty property = ktProperty;
        return property != null && KtModifierListKt.isConstant((KtModifierListOwner)property) && this.isLongProperty(property);
    }

    private final boolean isLongProperty(KtProperty property) {
        return this.hasLongType(property) || this.hasLongAssignment(property);
    }

    private final boolean hasLongType(KtProperty property) {
        KtTypeReference ktTypeReference = property.getTypeReference();
        return Intrinsics.areEqual((Object)(ktTypeReference != null ? ktTypeReference.getText() : null), (Object)"Long");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasLongAssignment(KtProperty property) {
        PsiElement[] psiElementArray = property.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray, (String)"property.children");
        PsiElement[] $this$singleOrNull$iv = psiElementArray;
        boolean $i$f$singleOrNull = false;
        PsiElement single$iv = null;
        boolean found$iv = false;
        PsiElement[] psiElementArray2 = $this$singleOrNull$iv;
        int n = psiElementArray2.length;
        for (int i = 0; i < n; ++i) {
            PsiElement element$iv;
            PsiElement it = element$iv = psiElementArray2[i];
            boolean bl = false;
            if (!(it instanceof KtConstantExpression || it instanceof KtPrefixExpression)) continue;
            if (found$iv) {
                return false;
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            return false;
        }
        PsiElement psiElement = single$iv;
        if (psiElement == null) return false;
        String string = psiElement.getText();
        String assignmentText = string;
        if (assignmentText == null) return false;
        if (StringsKt.last((CharSequence)assignmentText) != 'L') return false;
        String string2 = assignmentText;
        int n2 = 0;
        int n3 = assignmentText.length() - 1;
        boolean bl = false;
        String string3 = string2.substring(n2, n3);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        if (StringsKt.toLongOrNull((String)string3) == null) return false;
        return true;
    }

    public SerialVersionUIDInSerializableClass(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Warning, "A class which implements the Serializable interface does not define a correct serialVersionUID field. The serialVersionUID field should be a constant long value inside a companion object.", Debt.Companion.getFIVE_MINS());
        this.versionUID = "serialVersionUID";
    }

    public /* synthetic */ SerialVersionUIDInSerializableClass(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public SerialVersionUIDInSerializableClass() {
        this(null, 1, null);
    }
}

