/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.style.JunkKt;
import io.gitlab.arturbosch.detekt.rules.style.KtFileContent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/TrailingWhitespace;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "createMessage", "", "line", "", "hasTrailingWhitespace", "", "visit", "", "fileContent", "Lio/gitlab/arturbosch/detekt/rules/style/KtFileContent;", "detekt-rules"})
public final class TrailingWhitespace
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public final void visit(@NotNull KtFileContent fileContent) {
        Intrinsics.checkParameterIsNotNull((Object)fileContent, (String)"fileContent");
        int offset = 0;
        Sequence<String> $this$forEachIndexed$iv = fileContent.getContent();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            String string = (String)item$iv;
            int index = n2;
            boolean bl2 = false;
            offset += line.length();
            if (this.hasTrailingWhitespace((String)line)) {
                KtFile file = fileContent.getFile();
                PsiElement ktElement = JunkKt.findFirstKtElementInParents(file, offset, (String)line);
                if (ktElement != null) {
                    this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)ktElement, (int)0, (int)2, null), this.createMessage(index), null, null, 24, null));
                } else {
                    this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from((PsiElement)file, offset), this.createMessage(index), null, null, 24, null));
                }
            }
            ++offset;
        }
    }

    private final boolean hasTrailingWhitespace(String line) {
        CharSequence charSequence = line;
        boolean bl = false;
        return charSequence.length() > 0 && (StringsKt.last((CharSequence)line) == ' ' || StringsKt.last((CharSequence)line) == '\t');
    }

    private final String createMessage(int line) {
        return "Line " + (line + 1) + " ends with a whitespace.";
    }

    public TrailingWhitespace(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Checks which lines end with a whitespace.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ TrailingWhitespace(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public TrailingWhitespace() {
        this(null, 1, null);
    }
}

