/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style.optional;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/optional/PreferToOverPairSyntax;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitSimpleNameExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "Companion", "detekt-rules"})
public final class PreferToOverPairSyntax
extends Rule {
    @NotNull
    private final Issue issue;
    @NotNull
    public static final String PAIR_CONSTRUCTOR_REFERENCE_NAME = "kotlin.Pair";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    /*
     * WARNING - void declaration
     */
    public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression) {
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
            return;
        }
        KtElement ktElement = KtPsiUtilKt.getQualifiedElementOrCallableRef((KtSimpleNameExpression)expression);
        if (!(ktElement instanceof KtCallExpression)) {
            ktElement = null;
        }
        KtCallExpression ktCallExpression = (KtCallExpression)ktElement;
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression callReference = ktCallExpression;
        KotlinType kotlinType = CallUtilKt.getType((KtExpression)((KtExpression)callReference), (BindingContext)this.getBindingContext());
        if (!((kotlinType != null && (kotlinType = kotlinType.getConstructor()) != null ? kotlinType.getDeclarationDescriptor() : (classifierDescriptor = null)) instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor subjectType = classDescriptor;
        FqName fqName = DescriptorUtilsKt.fqNameOrNull((DeclarationDescriptor)((DeclarationDescriptor)subjectType));
        if (Intrinsics.areEqual((Object)(fqName != null ? fqName.asString() : null), (Object)PAIR_CONSTRUCTOR_REFERENCE_NAME)) {
            void firstArg;
            List list;
            void $this$mapTo$iv$iv;
            List list2 = callReference.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"callReference.valueArguments");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtValueArgument ktValueArgument = (KtValueArgument)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v7 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v7, (String)"it");
                String string = v7.getText();
                collection.add(string);
            }
            List list3 = list = (List)destination$iv$iv;
            boolean bl = false;
            String string = (String)list3.get(0);
            list3 = list;
            bl = false;
            String secondArg = (String)list3.get(1);
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "Pair is created by using the pair constructor. " + "This can replaced by `" + (String)firstArg + " to " + secondArg + '`', null, null, 24, null));
        }
        super.visitSimpleNameExpression(expression);
    }

    public PreferToOverPairSyntax(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("PreferToOverPairSyntax", Severity.Style, "Pair was created using the Pair constructor, using the to syntax is preferred.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ PreferToOverPairSyntax(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public PreferToOverPairSyntax() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/optional/PreferToOverPairSyntax$Companion;", "", "()V", "PAIR_CONSTRUCTOR_REFERENCE_NAME", "", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

