/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.api.http.stream;

import io.gravitee.gateway.api.Request;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.http.stream.TransformableRequestStreamBuilder;
import io.gravitee.gateway.api.http.stream.TransformableSourceStream;
import io.gravitee.gateway.api.stream.exception.TransformationException;
import io.gravitee.policy.api.PolicyResult;
import io.gravitee.reporter.api.log.Log;

public class TransformableRequestStream
extends TransformableSourceStream<Request> {
    TransformableRequestStream(TransformableRequestStreamBuilder builder) {
        super(builder);
    }

    @Override
    public void end() {
        try {
            String contentType;
            Buffer content = this.transform().apply(this.buffer);
            ((Request)this.source).headers().remove((Object)"Transfer-Encoding");
            if (content != null) {
                ((Request)this.source).headers().set("Content-Length", Integer.toString(content.length()));
            }
            if ((contentType = this.contentType()) != null && !contentType.isEmpty()) {
                ((Request)this.source).headers().set("Content-Type", contentType);
            }
            if (content != null) {
                super.flush(content);
            }
            super.end();
        }
        catch (TransformationException tex) {
            ((Request)this.source).metrics().setMessage(tex.getMessage());
            Log log = ((Request)this.source).metrics().getLog();
            if (log != null) {
                log.setProxyRequest(null);
            }
            if (this.policyChain != null) {
                this.policyChain.streamFailWith(PolicyResult.failure((int)500, (String)tex.getMessage()));
            }
            super.end();
        }
    }
}

