/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.api.http.stream;

import io.gravitee.gateway.api.Response;
import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.http.stream.TransformableResponseStreamBuilder;
import io.gravitee.gateway.api.http.stream.TransformableSourceStream;
import io.gravitee.gateway.api.stream.exception.TransformationException;
import io.gravitee.policy.api.PolicyResult;

public class TransformableResponseStream
extends TransformableSourceStream<Response> {
    TransformableResponseStream(TransformableResponseStreamBuilder builder) {
        super(builder);
    }

    @Override
    public void end() {
        try {
            String contentType;
            Buffer content = this.transform().apply(this.buffer);
            ((Response)this.source).headers().remove((Object)"Transfer-Encoding");
            if (content != null) {
                ((Response)this.source).headers().set("Content-Length", Integer.toString(content.length()));
            }
            if ((contentType = this.contentType()) != null && !contentType.isEmpty()) {
                ((Response)this.source).headers().set("Content-Type", contentType);
            }
            if (content != null) {
                super.flush(content);
            }
            super.end();
        }
        catch (TransformationException tex) {
            if (this.policyChain != null) {
                this.policyChain.streamFailWith(PolicyResult.failure((int)500, (String)tex.getMessage()));
            }
            super.end();
        }
    }
}

