/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.gateway.api.stream;

import io.gravitee.gateway.api.buffer.Buffer;
import io.gravitee.gateway.api.stream.BufferedReadWriteStream;
import io.gravitee.policy.api.PolicyChain;
import java.util.function.Function;

public abstract class TransformableStream
extends BufferedReadWriteStream {
    protected final Buffer buffer;
    protected String contentType;
    protected PolicyChain policyChain;
    protected Function<Buffer, Buffer> transform;

    public TransformableStream(int length) {
        this.buffer = length != -1 ? Buffer.buffer(length) : Buffer.buffer();
    }

    public TransformableStream() {
        this(-1);
    }

    public TransformableStream write(Buffer chunk) {
        this.buffer.appendBuffer(chunk);
        return this;
    }

    protected TransformableStream flush(Buffer chunk) {
        super.write(chunk);
        return this;
    }

    void contentType(String contentType) {
        this.contentType = contentType;
    }

    public String contentType() {
        return this.contentType;
    }

    void transform(Function<Buffer, Buffer> transform) {
        this.transform = transform;
    }

    public Function<Buffer, Buffer> transform() {
        return this.transform;
    }

    void policyChain(PolicyChain policyChain) {
        this.policyChain = policyChain;
    }

    public PolicyChain policyChain() {
        return this.policyChain;
    }
}

