/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.container;

import io.gravitee.common.component.Lifecycle;
import io.gravitee.common.component.LifecycleComponent;
import io.gravitee.common.service.AbstractService;
import io.gravitee.common.util.ListReverser;
import io.gravitee.common.util.Version;
import io.gravitee.node.api.Node;
import io.gravitee.node.management.http.ManagementService;
import io.gravitee.node.plugins.service.ServiceManager;
import io.gravitee.node.reporter.ReporterManager;
import io.gravitee.plugin.core.api.PluginRegistry;
import io.gravitee.plugin.core.internal.PluginEventListener;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractNode
extends AbstractService<Node>
implements Node,
ApplicationContextAware {
    protected final Logger LOGGER = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected ApplicationContext applicationContext;
    private String hostname;

    public AbstractNode() {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            this.LOGGER.warn("Could not get hostname / IP", (Throwable)uhe);
        }
    }

    protected void doStart() throws Exception {
        this.LOGGER.info("{} is now starting...", (Object)this.name());
        long startTime = System.currentTimeMillis();
        List<Class<? extends LifecycleComponent>> components = this.components();
        for (Class<? extends LifecycleComponent> componentClass : components) {
            this.LOGGER.info("\tStarting component: {}", (Object)componentClass.getSimpleName());
            try {
                LifecycleComponent lifecyclecomponent = (LifecycleComponent)this.applicationContext.getBean(componentClass);
                lifecyclecomponent.start();
            }
            catch (Exception var7) {
                this.LOGGER.error("An error occurs while starting component {}", (Object)componentClass.getSimpleName(), (Object)var7);
                throw var7;
            }
        }
        long endTime = System.currentTimeMillis();
        String processId = ManagementFactory.getRuntimeMXBean().getName();
        if (processId.contains("@")) {
            processId = processId.split("@")[0];
        }
        this.LOGGER.info("{} id[{}] version[{}] pid[{}] build[{}#{}] jvm[{}/{}/{}] started in {} ms.", new Object[]{this.name(), this.id(), Version.RUNTIME_VERSION.MAJOR_VERSION, processId, Version.RUNTIME_VERSION.BUILD_NUMBER, Version.RUNTIME_VERSION.REVISION, ManagementFactory.getRuntimeMXBean().getVmVendor(), ManagementFactory.getRuntimeMXBean().getVmName(), ManagementFactory.getRuntimeMXBean().getVmVersion(), endTime - startTime});
    }

    protected void doStop() throws Exception {
        this.LOGGER.info("{} is stopping", (Object)this.name());
        ListReverser components = new ListReverser(this.components());
        for (Class componentClass : components) {
            try {
                LifecycleComponent lifecyclecomponent = (LifecycleComponent)this.applicationContext.getBean(componentClass);
                if (lifecyclecomponent.lifecycleState() != Lifecycle.State.STARTED) continue;
                this.LOGGER.info("\tStopping component: {}", (Object)componentClass.getSimpleName());
                lifecyclecomponent.stop();
            }
            catch (Exception var5) {
                this.LOGGER.error("An error occurs while stopping component {}", (Object)componentClass.getSimpleName(), (Object)var5);
            }
        }
        this.LOGGER.info("{} stopped", (Object)this.name());
    }

    public String hostname() {
        return this.hostname;
    }

    public abstract String name();

    public List<Class<? extends LifecycleComponent>> components() {
        ArrayList<Class<? extends LifecycleComponent>> components = new ArrayList<Class<? extends LifecycleComponent>>();
        components.add(PluginEventListener.class);
        components.add(PluginRegistry.class);
        components.add(ServiceManager.class);
        components.add(ManagementService.class);
        components.add(ReporterManager.class);
        return components;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

