/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.node.container.spring;

import io.gravitee.node.api.Node;
import io.gravitee.node.container.AbstractContainer;
import io.gravitee.node.container.spring.NodeConfiguration;
import io.gravitee.node.container.spring.env.EnvironmentConfiguration;
import io.gravitee.node.container.spring.env.PropertiesConfiguration;
import io.gravitee.node.management.http.spring.ManagementConfiguration;
import io.gravitee.node.plugins.service.spring.ServiceConfiguration;
import io.gravitee.node.reporter.spring.ReporterConfiguration;
import io.gravitee.plugin.core.spring.PluginConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public abstract class SpringBasedContainer
extends AbstractContainer {
    private ConfigurableApplicationContext ctx;

    @Override
    protected void initialize() {
        super.initialize();
        this.initializeContext();
    }

    protected void initializeContext() {
        this.ctx = new AnnotationConfigApplicationContext();
        List<Class<?>> classes = this.annotatedClasses();
        classes.forEach(aClass -> ((AnnotationConfigApplicationContext)this.ctx).register(new Class[]{aClass}));
        this.ctx.refresh();
    }

    protected List<Class<?>> annotatedClasses() {
        ArrayList classes = new ArrayList();
        classes.add(EnvironmentConfiguration.class);
        classes.add(PropertiesConfiguration.class);
        classes.add(PluginConfiguration.class);
        classes.add(ServiceConfiguration.class);
        classes.add(ManagementConfiguration.class);
        classes.add(ReporterConfiguration.class);
        classes.add(NodeConfiguration.class);
        return classes;
    }

    @Override
    protected void doStop() throws Exception {
        if (!this.stopped) {
            LoggerFactory.getLogger(this.getClass()).info("Shutting-down {}...", (Object)this.name());
            try {
                this.node().stop();
            }
            catch (Exception ex) {
                LoggerFactory.getLogger(this.getClass()).error("Unexpected error", (Throwable)ex);
            }
            finally {
                this.ctx.close();
                this.stopped = true;
            }
        }
    }

    @Override
    public Node node() {
        return (Node)this.ctx.getBean(Node.class);
    }

    public ApplicationContext applicationContext() {
        return this.ctx;
    }
}

