/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.analytics.query;

import io.gravitee.repository.analytics.query.BetweenDateRange;
import io.gravitee.repository.analytics.query.DateRange;
import io.gravitee.repository.analytics.query.SinceDateRange;
import java.time.temporal.ChronoUnit;

public class DateRangeBuilder {
    public static DateRange between(long startTime, long endTime) {
        BetweenDateRange betweenQuery = new BetweenDateRange();
        betweenQuery.setStart(startTime);
        betweenQuery.setEnd(endTime);
        return betweenQuery;
    }

    public static DateRange lastMonth() {
        return DateRangeBuilder.lastMonths(1);
    }

    public static DateRange lastDay() {
        return DateRangeBuilder.lastDays(1);
    }

    public static DateRange lastHour() {
        return DateRangeBuilder.lastHours(1);
    }

    public static DateRange lastMinute() {
        return DateRangeBuilder.lastMinutes(1);
    }

    public static DateRange lastDays(int days) {
        SinceDateRange sinceQuery = new SinceDateRange();
        sinceQuery.setChronoUnit(ChronoUnit.DAYS);
        sinceQuery.setTime(days);
        return sinceQuery;
    }

    public static DateRange lastMonths(int months) {
        SinceDateRange sinceQuery = new SinceDateRange();
        sinceQuery.setChronoUnit(ChronoUnit.MONTHS);
        sinceQuery.setTime(months);
        return sinceQuery;
    }

    public static DateRange lastHours(int hours) {
        SinceDateRange sinceQuery = new SinceDateRange();
        sinceQuery.setChronoUnit(ChronoUnit.HOURS);
        sinceQuery.setTime(hours);
        return sinceQuery;
    }

    public static DateRange lastMinutes(int minutes) {
        SinceDateRange sinceQuery = new SinceDateRange();
        sinceQuery.setChronoUnit(ChronoUnit.MINUTES);
        sinceQuery.setTime(minutes);
        return sinceQuery;
    }
}

