/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.api.search;

import io.gravitee.repository.management.model.ApiLifecycleState;
import io.gravitee.repository.management.model.LifecycleState;
import io.gravitee.repository.management.model.Visibility;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ApiCriteria {
    private List<String> ids;
    private List<String> groups;
    private String view;
    private String label;
    private LifecycleState state;
    private Visibility visibility;
    private String version;
    private String name;
    private List<ApiLifecycleState> lifecycleStates;

    ApiCriteria(Builder builder) {
        this.ids = builder.ids;
        this.groups = builder.groups;
        this.view = builder.view;
        this.label = builder.label;
        this.state = builder.state;
        this.visibility = builder.visibility;
        this.version = builder.version;
        this.name = builder.name;
        this.lifecycleStates = builder.lifecycleStates;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String getView() {
        return this.view;
    }

    public String getLabel() {
        return this.label;
    }

    public LifecycleState getState() {
        return this.state;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public List<ApiLifecycleState> getLifecycleStates() {
        return this.lifecycleStates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApiCriteria)) {
            return false;
        }
        ApiCriteria that = (ApiCriteria)o;
        return Objects.equals(this.ids, that.ids) && Objects.equals(this.groups, that.groups) && Objects.equals(this.view, that.view) && Objects.equals(this.label, that.label) && Objects.equals((Object)this.state, (Object)that.state) && Objects.equals((Object)this.visibility, (Object)that.visibility) && Objects.equals(this.version, that.version) && Objects.equals(this.name, that.name) && Objects.equals(this.lifecycleStates, that.lifecycleStates);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.ids, this.groups, this.view, this.label, this.state, this.visibility, this.version, this.name, this.lifecycleStates});
    }

    public static class Builder {
        private List<String> ids;
        private List<String> groups;
        private String view;
        private String label;
        private LifecycleState state;
        private Visibility visibility;
        private String version;
        private String name;
        private List<ApiLifecycleState> lifecycleStates;

        public Builder ids(String ... id) {
            this.ids = Arrays.asList(id);
            return this;
        }

        public Builder groups(String ... group) {
            this.groups = Arrays.asList(group);
            return this;
        }

        public Builder view(String view) {
            this.view = view;
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            return this;
        }

        public Builder state(LifecycleState state) {
            this.state = state;
            return this;
        }

        public Builder visibility(Visibility visibility) {
            this.visibility = visibility;
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder lifecycleStates(List<ApiLifecycleState> lifecycleStates) {
            this.lifecycleStates = lifecycleStates;
            return this;
        }

        public ApiCriteria build() {
            return new ApiCriteria(this);
        }
    }
}

