/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.repository.management.model;

import io.gravitee.repository.management.model.Audit;
import io.gravitee.repository.management.model.MembershipReferenceType;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Membership {
    private String userId;
    private String referenceId;
    private MembershipReferenceType referenceType;
    private Map<Integer, String> roles;
    private Date createdAt;
    private Date updatedAt;

    public Membership() {
    }

    public Membership(String userId, String referenceId, MembershipReferenceType referenceType) {
        this.userId = userId;
        this.referenceId = referenceId;
        this.referenceType = referenceType;
    }

    public Membership(Membership cloned) {
        this.userId = cloned.userId;
        this.referenceId = cloned.referenceId;
        this.referenceType = cloned.referenceType;
        this.roles = new HashMap<Integer, String>(cloned.roles);
        this.createdAt = cloned.createdAt;
        this.updatedAt = cloned.updatedAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Map<Integer, String> getRoles() {
        return this.roles;
    }

    public void setRoles(Map<Integer, String> roles) {
        this.roles = roles;
    }

    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public void setUpdatedAt(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public MembershipReferenceType getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(MembershipReferenceType referenceType) {
        this.referenceType = referenceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Membership m = (Membership)o;
        return Objects.equals(this.userId, m.userId) && Objects.equals(this.referenceId, m.referenceId) && Objects.equals((Object)this.referenceType, (Object)m.referenceType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.userId, this.referenceId, this.referenceType});
    }

    public String toString() {
        return "Membership{userId='" + this.userId + '\'' + ", referenceId='" + this.referenceId + '\'' + ", referenceType='" + (Object)((Object)this.referenceType) + '\'' + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + '}';
    }

    public static enum AuditEvent implements Audit.ApiAuditEvent
    {
        MEMBERSHIP_CREATED,
        MEMBERSHIP_UPDATED,
        MEMBERSHIP_DELETED;

    }
}

