/*
 * Decompiled with CFR 0.152.
 */
package io.gravitee.resource.cache;

import io.gravitee.resource.api.AbstractConfigurableResource;
import io.gravitee.resource.cache.Cache;
import io.gravitee.resource.cache.configuration.CacheResourceConfiguration;
import io.gravitee.resource.cache.ehcache.EhCacheDelegate;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheResource
extends AbstractConfigurableResource<CacheResourceConfiguration> {
    private final Logger LOGGER = LoggerFactory.getLogger(CacheResource.class);
    private CacheManager cacheManager;
    private Cache cache;

    protected void doStart() throws Exception {
        super.doStart();
        Configuration configuration = new Configuration();
        configuration.setName(((CacheResourceConfiguration)this.configuration()).getName());
        this.cacheManager = new CacheManager(configuration);
        CacheConfiguration cacheConfiguration = new CacheConfiguration();
        cacheConfiguration.setEternal(false);
        cacheConfiguration.setTimeToIdleSeconds(((CacheResourceConfiguration)this.configuration()).getTimeToIdleSeconds());
        cacheConfiguration.setTimeToLiveSeconds(((CacheResourceConfiguration)this.configuration()).getTimeToLiveSeconds());
        cacheConfiguration.setMaxEntriesLocalHeap(((CacheResourceConfiguration)this.configuration()).getMaxEntriesLocalHeap());
        cacheConfiguration.setName(((CacheResourceConfiguration)this.configuration()).getName());
        this.LOGGER.info("Create a new cache: {}", (Object)((CacheResourceConfiguration)this.configuration()).getName());
        net.sf.ehcache.Cache ehCache = new net.sf.ehcache.Cache(cacheConfiguration);
        this.cache = new EhCacheDelegate((Ehcache)ehCache);
        this.cacheManager.addCache(ehCache);
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.cacheManager != null) {
            this.LOGGER.info("Clear cache {}", (Object)((CacheResourceConfiguration)this.configuration()).getName());
            this.cacheManager.shutdown();
        }
    }

    public Cache getCache() {
        return this.cache;
    }
}

