/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.CallCredentials;
import io.grpc.CallOptions;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.SecurityLevel;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.ForwardingConnectionClientTransport;
import io.grpc.internal.MetadataApplierImpl;
import io.grpc.internal.StatsTraceContext;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

final class CallCredentialsApplyingTransportFactory
implements ClientTransportFactory {
    private final ClientTransportFactory delegate;
    private final Executor appExecutor;

    CallCredentialsApplyingTransportFactory(ClientTransportFactory delegate, Executor appExecutor) {
        this.delegate = (ClientTransportFactory)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
        this.appExecutor = (Executor)Preconditions.checkNotNull((Object)appExecutor, (Object)"appExecutor");
    }

    @Override
    public ConnectionClientTransport newClientTransport(SocketAddress serverAddress, String authority, @Nullable String userAgent) {
        return new CallCredentialsApplyingTransport(this.delegate.newClientTransport(serverAddress, authority, userAgent), authority);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    private class CallCredentialsApplyingTransport
    extends ForwardingConnectionClientTransport {
        private final ConnectionClientTransport delegate;
        private final String authority;

        CallCredentialsApplyingTransport(ConnectionClientTransport delegate, String authority) {
            this.delegate = (ConnectionClientTransport)Preconditions.checkNotNull((Object)delegate, (Object)"delegate");
            this.authority = (String)Preconditions.checkNotNull((Object)authority, (Object)"authority");
        }

        @Override
        protected ConnectionClientTransport delegate() {
            return this.delegate;
        }

        @Override
        public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, StatsTraceContext statsTraceCtx) {
            CallCredentials creds = callOptions.getCredentials();
            if (creds != null) {
                MetadataApplierImpl applier = new MetadataApplierImpl(this.delegate, method, headers, callOptions, statsTraceCtx);
                Attributes.Builder effectiveAttrsBuilder = Attributes.newBuilder().set(CallCredentials.ATTR_AUTHORITY, this.authority).set(CallCredentials.ATTR_SECURITY_LEVEL, SecurityLevel.NONE).setAll(this.delegate.getAttributes());
                if (callOptions.getAuthority() != null) {
                    effectiveAttrsBuilder.set(CallCredentials.ATTR_AUTHORITY, callOptions.getAuthority());
                }
                creds.applyRequestMetadata(method, effectiveAttrsBuilder.build(), (Executor)MoreObjects.firstNonNull((Object)callOptions.getExecutor(), (Object)CallCredentialsApplyingTransportFactory.this.appExecutor), applier);
                return applier.returnStream();
            }
            return this.delegate.newStream(method, headers, callOptions, statsTraceCtx);
        }
    }
}

