/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import io.grpc.Channel;
import io.grpc.Context;
import io.grpc.InternalLogId;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.stub.StreamObserver;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.LoadStatsManager2;
import io.grpc.xds.Stats;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Locality;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.ClusterStats;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.UpstreamLocalityStats;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterStats;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v2.LoadReportingServiceGrpc;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v2.LoadStatsRequest;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v2.LoadStatsResponse;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v3.LoadReportingServiceGrpc;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v3.LoadStatsRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class LoadReportClient {
    private final InternalLogId logId;
    private final XdsLogger logger;
    private final Channel channel;
    private final Context context;
    private final boolean useProtocolV3;
    private final EnvoyProtoData.Node node;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timerService;
    private final Stopwatch retryStopwatch;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final LoadStatsManager2 loadStatsManager;
    private boolean started;
    @Nullable
    private BackoffPolicy lrsRpcRetryPolicy;
    @Nullable
    private SynchronizationContext.ScheduledHandle lrsRpcRetryTimer;
    @Nullable
    private LrsStream lrsStream;

    LoadReportClient(LoadStatsManager2 loadStatsManager, Channel channel, Context context, boolean useProtocolV3, EnvoyProtoData.Node node, SynchronizationContext syncContext, ScheduledExecutorService scheduledExecutorService, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier) {
        this.loadStatsManager = (LoadStatsManager2)Preconditions.checkNotNull((Object)loadStatsManager, (Object)"loadStatsManager");
        this.channel = (Channel)Preconditions.checkNotNull((Object)channel, (Object)"xdsChannel");
        this.context = (Context)Preconditions.checkNotNull((Object)context, (Object)"context");
        this.useProtocolV3 = useProtocolV3;
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)syncContext, (Object)"syncContext");
        this.timerService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService, (Object)"timeService");
        this.backoffPolicyProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)backoffPolicyProvider, (Object)"backoffPolicyProvider");
        this.retryStopwatch = (Stopwatch)((Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatchSupplier")).get();
        this.node = ((EnvoyProtoData.Node)Preconditions.checkNotNull((Object)node, (Object)"node")).toBuilder().addClientFeatures("envoy.lrs.supports_send_all_clusters").build();
        this.logId = InternalLogId.allocate((String)"lrs-client", null);
        this.logger = XdsLogger.withLogId(this.logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    void startLoadReporting() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.started) {
            return;
        }
        this.started = true;
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Starting load reporting RPC");
        this.startLrsRpc();
    }

    void stopLoadReporting() {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (!this.started) {
            return;
        }
        this.started = false;
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Stopping load reporting RPC");
        if (this.lrsRpcRetryTimer != null && this.lrsRpcRetryTimer.isPending()) {
            this.lrsRpcRetryTimer.cancel();
        }
        if (this.lrsStream != null) {
            this.lrsStream.close((Exception)((Object)Status.CANCELLED.withDescription("stop load reporting").asException()));
        }
    }

    private void startLrsRpc() {
        if (!this.started) {
            return;
        }
        Preconditions.checkState((this.lrsStream == null ? 1 : 0) != 0, (Object)"previous lbStream has not been cleared yet");
        this.lrsStream = this.useProtocolV3 ? new LrsStreamV3() : new LrsStreamV2();
        this.retryStopwatch.reset().start();
        Context prevContext = this.context.attach();
        try {
            this.lrsStream.start();
        }
        finally {
            this.context.detach(prevContext);
        }
    }

    private final class LrsStreamV3
    extends LrsStream {
        StreamObserver<LoadStatsRequest> lrsRequestWriterV3;

        private LrsStreamV3() {
        }

        @Override
        void start() {
            StreamObserver<io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v3.LoadStatsResponse> lrsResponseReaderV3 = new StreamObserver<io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v3.LoadStatsResponse>(){

                public void onNext(final io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v3.LoadStatsResponse response) {
                    LoadReportClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received LRS response:\n{0}", response);
                            LrsStreamV3.this.handleRpcResponse((List<String>)response.getClustersList(), response.getSendAllClusters(), Durations.toNanos((Duration)response.getLoadReportingInterval()));
                        }
                    });
                }

                public void onError(final Throwable t) {
                    LoadReportClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            LrsStreamV3.this.handleRpcError(t);
                        }
                    });
                }

                public void onCompleted() {
                    LoadReportClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            LrsStreamV3.this.handleRpcCompleted();
                        }
                    });
                }
            };
            LoadReportingServiceGrpc.LoadReportingServiceStub stubV3 = LoadReportingServiceGrpc.newStub(LoadReportClient.this.channel);
            this.lrsRequestWriterV3 = ((LoadReportingServiceGrpc.LoadReportingServiceStub)stubV3.withWaitForReady()).streamLoadStats(lrsResponseReaderV3);
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sending initial LRS request");
            this.sendLoadStatsRequest(Collections.emptyList());
        }

        @Override
        void sendLoadStatsRequest(List<Stats.ClusterStats> clusterStatsList) {
            LoadStatsRequest.Builder requestBuilder = LoadStatsRequest.newBuilder().setNode(LoadReportClient.this.node.toEnvoyProtoNode());
            for (Stats.ClusterStats stats : clusterStatsList) {
                requestBuilder.addClusterStats(this.buildClusterStats(stats));
            }
            LoadStatsRequest request = requestBuilder.build();
            this.lrsRequestWriterV3.onNext((Object)request);
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sent LoadStatsRequest\n{0}", request);
        }

        @Override
        void sendError(Exception error) {
            this.lrsRequestWriterV3.onError((Throwable)error);
        }

        private io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterStats buildClusterStats(Stats.ClusterStats stats) {
            ClusterStats.Builder builder = io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterStats.newBuilder().setClusterName(stats.clusterName());
            if (stats.clusterServiceName() != null) {
                builder.setClusterServiceName(stats.clusterServiceName());
            }
            for (Stats.UpstreamLocalityStats upstreamLocalityStats : stats.upstreamLocalityStatsList()) {
                builder.addUpstreamLocalityStats(io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.UpstreamLocalityStats.newBuilder().setLocality(io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Locality.newBuilder().setRegion(upstreamLocalityStats.locality().region()).setZone(upstreamLocalityStats.locality().zone()).setSubZone(upstreamLocalityStats.locality().subZone())).setTotalSuccessfulRequests(upstreamLocalityStats.totalSuccessfulRequests()).setTotalErrorRequests(upstreamLocalityStats.totalErrorRequests()).setTotalRequestsInProgress(upstreamLocalityStats.totalRequestsInProgress()).setTotalIssuedRequests(upstreamLocalityStats.totalIssuedRequests()));
            }
            for (Stats.DroppedRequests droppedRequests : stats.droppedRequestsList()) {
                builder.addDroppedRequests(ClusterStats.DroppedRequests.newBuilder().setCategory(droppedRequests.category()).setDroppedCount(droppedRequests.droppedCount()));
            }
            return builder.setTotalDroppedRequests(stats.totalDroppedRequests()).setLoadReportInterval(Durations.fromNanos((long)stats.loadReportIntervalNano())).build();
        }
    }

    private final class LrsStreamV2
    extends LrsStream {
        StreamObserver<io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v2.LoadStatsRequest> lrsRequestWriterV2;

        private LrsStreamV2() {
        }

        @Override
        void start() {
            StreamObserver<LoadStatsResponse> lrsResponseReaderV2 = new StreamObserver<LoadStatsResponse>(){

                public void onNext(final LoadStatsResponse response) {
                    LoadReportClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received LoadStatsResponse:\n{0}", response);
                            LrsStreamV2.this.handleRpcResponse((List<String>)response.getClustersList(), response.getSendAllClusters(), Durations.toNanos((Duration)response.getLoadReportingInterval()));
                        }
                    });
                }

                public void onError(final Throwable t) {
                    LoadReportClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            LrsStreamV2.this.handleRpcError(t);
                        }
                    });
                }

                public void onCompleted() {
                    LoadReportClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            LrsStreamV2.this.handleRpcCompleted();
                        }
                    });
                }
            };
            LoadReportingServiceGrpc.LoadReportingServiceStub stubV2 = io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v2.LoadReportingServiceGrpc.newStub(LoadReportClient.this.channel);
            this.lrsRequestWriterV2 = ((LoadReportingServiceGrpc.LoadReportingServiceStub)stubV2.withWaitForReady()).streamLoadStats(lrsResponseReaderV2);
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sending initial LRS request");
            this.sendLoadStatsRequest(Collections.emptyList());
        }

        @Override
        void sendLoadStatsRequest(List<Stats.ClusterStats> clusterStatsList) {
            LoadStatsRequest.Builder requestBuilder = io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v2.LoadStatsRequest.newBuilder().setNode(LoadReportClient.this.node.toEnvoyProtoNodeV2());
            for (Stats.ClusterStats stats : clusterStatsList) {
                requestBuilder.addClusterStats(this.buildClusterStats(stats));
            }
            io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v2.LoadStatsRequest request = requestBuilder.build();
            this.lrsRequestWriterV2.onNext((Object)requestBuilder.build());
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sent LoadStatsRequest\n{0}", request);
        }

        @Override
        void sendError(Exception error) {
            this.lrsRequestWriterV2.onError((Throwable)error);
        }

        private ClusterStats buildClusterStats(Stats.ClusterStats stats) {
            ClusterStats.Builder builder = ClusterStats.newBuilder().setClusterName(stats.clusterName());
            if (stats.clusterServiceName() != null) {
                builder.setClusterServiceName(stats.clusterServiceName());
            }
            for (Stats.UpstreamLocalityStats upstreamLocalityStats : stats.upstreamLocalityStatsList()) {
                builder.addUpstreamLocalityStats(UpstreamLocalityStats.newBuilder().setLocality(Locality.newBuilder().setRegion(upstreamLocalityStats.locality().region()).setZone(upstreamLocalityStats.locality().zone()).setSubZone(upstreamLocalityStats.locality().subZone())).setTotalSuccessfulRequests(upstreamLocalityStats.totalSuccessfulRequests()).setTotalErrorRequests(upstreamLocalityStats.totalErrorRequests()).setTotalRequestsInProgress(upstreamLocalityStats.totalRequestsInProgress()).setTotalIssuedRequests(upstreamLocalityStats.totalIssuedRequests()));
            }
            for (Stats.DroppedRequests droppedRequests : stats.droppedRequestsList()) {
                builder.addDroppedRequests(ClusterStats.DroppedRequests.newBuilder().setCategory(droppedRequests.category()).setDroppedCount(droppedRequests.droppedCount()));
            }
            return builder.setTotalDroppedRequests(stats.totalDroppedRequests()).setLoadReportInterval(Durations.fromNanos((long)stats.loadReportIntervalNano())).build();
        }
    }

    private abstract class LrsStream {
        boolean initialResponseReceived;
        boolean closed;
        long intervalNano = -1L;
        boolean reportAllClusters;
        List<String> clusterNames;
        SynchronizationContext.ScheduledHandle loadReportTimer;

        private LrsStream() {
        }

        abstract void start();

        abstract void sendLoadStatsRequest(List<Stats.ClusterStats> var1);

        abstract void sendError(Exception var1);

        final void handleRpcResponse(List<String> clusters, boolean sendAllClusters, long loadReportIntervalNano) {
            if (this.closed) {
                return;
            }
            if (!this.initialResponseReceived) {
                LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Initial LRS response received");
                this.initialResponseReceived = true;
            }
            this.reportAllClusters = sendAllClusters;
            if (this.reportAllClusters) {
                LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Report loads for all clusters");
            } else {
                LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Report loads for clusters: ", clusters);
                this.clusterNames = clusters;
            }
            this.intervalNano = loadReportIntervalNano;
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Update load reporting interval to {0} ns", this.intervalNano);
            this.scheduleNextLoadReport();
        }

        final void handleRpcError(Throwable t) {
            this.handleStreamClosed(Status.fromThrowable((Throwable)t));
        }

        final void handleRpcCompleted() {
            this.handleStreamClosed(Status.UNAVAILABLE.withDescription("Closed by server"));
        }

        private void sendLoadReport() {
            ArrayList<Stats.ClusterStats> clusterStatsList;
            if (this.closed) {
                return;
            }
            if (this.reportAllClusters) {
                clusterStatsList = LoadReportClient.this.loadStatsManager.getAllClusterStatsReports();
            } else {
                clusterStatsList = new ArrayList();
                for (String name : this.clusterNames) {
                    clusterStatsList.addAll(LoadReportClient.this.loadStatsManager.getClusterStatsReports(name));
                }
            }
            this.sendLoadStatsRequest(clusterStatsList);
            this.scheduleNextLoadReport();
        }

        private void scheduleNextLoadReport() {
            if (this.loadReportTimer != null && this.loadReportTimer.isPending()) {
                this.loadReportTimer.cancel();
                this.loadReportTimer = null;
            }
            if (this.intervalNano > 0L) {
                this.loadReportTimer = LoadReportClient.this.syncContext.schedule((Runnable)new LoadReportingTask(this), this.intervalNano, TimeUnit.NANOSECONDS, LoadReportClient.this.timerService);
            }
        }

        private void handleStreamClosed(Status status) {
            Preconditions.checkArgument((!status.isOk() ? 1 : 0) != 0, (Object)"unexpected OK status");
            if (this.closed) {
                return;
            }
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.ERROR, "LRS stream closed with status {0}: {1}. Cause: {2}", status.getCode(), status.getDescription(), status.getCause());
            this.closed = true;
            this.cleanUp();
            long delayNanos = 0L;
            if (this.initialResponseReceived || LoadReportClient.this.lrsRpcRetryPolicy == null) {
                LoadReportClient.this.lrsRpcRetryPolicy = LoadReportClient.this.backoffPolicyProvider.get();
            }
            if (!this.initialResponseReceived) {
                delayNanos = LoadReportClient.this.lrsRpcRetryPolicy.nextBackoffNanos() - LoadReportClient.this.retryStopwatch.elapsed(TimeUnit.NANOSECONDS);
            }
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Retry LRS stream in {0} ns", delayNanos);
            if (delayNanos <= 0L) {
                LoadReportClient.this.startLrsRpc();
            } else {
                LoadReportClient.this.lrsRpcRetryTimer = LoadReportClient.this.syncContext.schedule((Runnable)new LrsRpcRetryTask(), delayNanos, TimeUnit.NANOSECONDS, LoadReportClient.this.timerService);
            }
        }

        private void close(Exception error) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            this.sendError(error);
        }

        private void cleanUp() {
            if (this.loadReportTimer != null && this.loadReportTimer.isPending()) {
                this.loadReportTimer.cancel();
                this.loadReportTimer = null;
            }
            if (LoadReportClient.this.lrsStream == this) {
                LoadReportClient.this.lrsStream = null;
            }
        }
    }

    @VisibleForTesting
    class LrsRpcRetryTask
    implements Runnable {
        LrsRpcRetryTask() {
        }

        @Override
        public void run() {
            LoadReportClient.this.startLrsRpc();
        }
    }

    @VisibleForTesting
    static class LoadReportingTask
    implements Runnable {
        private final LrsStream stream;

        LoadReportingTask(LrsStream stream) {
            this.stream = stream;
        }

        @Override
        public void run() {
            this.stream.sendLoadReport();
        }
    }
}

