/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.protobuf.Any;
import io.grpc.Channel;
import io.grpc.Context;
import io.grpc.InternalLogId;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.stub.StreamObserver;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.ClientXdsClient;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.MessagePrinter;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.DiscoveryRequest;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.DiscoveryResponse;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v2.AggregatedDiscoveryServiceGrpc;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.AggregatedDiscoveryServiceGrpc;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class AbstractXdsClient {
    private static final String ADS_TYPE_URL_LDS_V2 = "type.googleapis.com/envoy.api.v2.Listener";
    private static final String ADS_TYPE_URL_LDS = "type.googleapis.com/envoy.config.listener.v3.Listener";
    private static final String ADS_TYPE_URL_RDS_V2 = "type.googleapis.com/envoy.api.v2.RouteConfiguration";
    private static final String ADS_TYPE_URL_RDS = "type.googleapis.com/envoy.config.route.v3.RouteConfiguration";
    @VisibleForTesting
    static final String ADS_TYPE_URL_CDS_V2 = "type.googleapis.com/envoy.api.v2.Cluster";
    private static final String ADS_TYPE_URL_CDS = "type.googleapis.com/envoy.config.cluster.v3.Cluster";
    private static final String ADS_TYPE_URL_EDS_V2 = "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment";
    private static final String ADS_TYPE_URL_EDS = "type.googleapis.com/envoy.config.endpoint.v3.ClusterLoadAssignment";
    private final SynchronizationContext syncContext;
    private final InternalLogId logId;
    private final XdsLogger logger;
    private final Bootstrapper.ServerInfo serverInfo;
    private final ManagedChannel channel;
    private final XdsClient.XdsResponseHandler xdsResponseHandler;
    private final XdsClient.ResourceStore resourceStore;
    private final Context context;
    private final ScheduledExecutorService timeService;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Stopwatch stopwatch;
    private final EnvoyProtoData.Node bootstrapNode;
    private String ldsVersion = "";
    private String rdsVersion = "";
    private String cdsVersion = "";
    private String edsVersion = "";
    private boolean shutdown;
    @Nullable
    private AbstractAdsStream adsStream;
    @Nullable
    private BackoffPolicy retryBackoffPolicy;
    @Nullable
    private SynchronizationContext.ScheduledHandle rpcRetryTimer;

    AbstractXdsClient(ClientXdsClient.XdsChannelFactory xdsChannelFactory, Bootstrapper.ServerInfo serverInfo, EnvoyProtoData.Node bootstrapNode, XdsClient.XdsResponseHandler xdsResponseHandler, XdsClient.ResourceStore resourceStore, Context context, ScheduledExecutorService timeService, SynchronizationContext syncContext, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier) {
        this.serverInfo = (Bootstrapper.ServerInfo)Preconditions.checkNotNull((Object)serverInfo, (Object)"serverInfo");
        this.channel = ((ClientXdsClient.XdsChannelFactory)Preconditions.checkNotNull((Object)xdsChannelFactory, (Object)"xdsChannelFactory")).create(serverInfo);
        this.xdsResponseHandler = (XdsClient.XdsResponseHandler)Preconditions.checkNotNull((Object)xdsResponseHandler, (Object)"xdsResponseHandler");
        this.resourceStore = (XdsClient.ResourceStore)Preconditions.checkNotNull((Object)resourceStore, (Object)"resourcesSubscriber");
        this.bootstrapNode = (EnvoyProtoData.Node)Preconditions.checkNotNull((Object)bootstrapNode, (Object)"bootstrapNode");
        this.context = (Context)Preconditions.checkNotNull((Object)context, (Object)"context");
        this.timeService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)timeService, (Object)"timeService");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)syncContext, (Object)"syncContext");
        this.backoffPolicyProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)backoffPolicyProvider, (Object)"backoffPolicyProvider");
        this.stopwatch = (Stopwatch)((Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatchSupplier")).get();
        this.logId = InternalLogId.allocate((String)"xds-client", (String)serverInfo.target());
        this.logger = XdsLogger.withLogId(this.logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    Channel channel() {
        return this.channel;
    }

    void shutdown() {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                AbstractXdsClient.this.shutdown = true;
                AbstractXdsClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutting down");
                if (AbstractXdsClient.this.adsStream != null) {
                    AbstractXdsClient.this.adsStream.close((Exception)((Object)Status.CANCELLED.withDescription("shutdown").asException()));
                }
                if (AbstractXdsClient.this.rpcRetryTimer != null && AbstractXdsClient.this.rpcRetryTimer.isPending()) {
                    AbstractXdsClient.this.rpcRetryTimer.cancel();
                }
                AbstractXdsClient.this.channel.shutdown();
            }
        });
    }

    public String toString() {
        return this.logId.toString();
    }

    void adjustResourceSubscription(ResourceType type) {
        Collection<String> resources;
        if (this.isInBackoff()) {
            return;
        }
        if (this.adsStream == null) {
            this.startRpcStream();
        }
        if ((resources = this.resourceStore.getSubscribedResources(this.serverInfo, type)) != null) {
            this.adsStream.sendDiscoveryRequest(type, resources);
        }
    }

    void ackResponse(ResourceType type, String versionInfo, String nonce) {
        switch (type) {
            case LDS: {
                this.ldsVersion = versionInfo;
                break;
            }
            case RDS: {
                this.rdsVersion = versionInfo;
                break;
            }
            case CDS: {
                this.cdsVersion = versionInfo;
                break;
            }
            case EDS: {
                this.edsVersion = versionInfo;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown resource type: " + (Object)((Object)type)));
            }
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending ACK for {0} update, nonce: {1}, current version: {2}", new Object[]{type, nonce, versionInfo});
        Collection<String> resources = this.resourceStore.getSubscribedResources(this.serverInfo, type);
        if (resources == null) {
            resources = Collections.emptyList();
        }
        this.adsStream.sendDiscoveryRequest(type, versionInfo, resources, nonce, null);
    }

    void nackResponse(ResourceType type, String nonce, String errorDetail) {
        String versionInfo = this.getCurrentVersion(type);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending NACK for {0} update, nonce: {1}, current version: {2}", new Object[]{type, nonce, versionInfo});
        Collection<String> resources = this.resourceStore.getSubscribedResources(this.serverInfo, type);
        if (resources == null) {
            resources = Collections.emptyList();
        }
        this.adsStream.sendDiscoveryRequest(type, versionInfo, resources, nonce, errorDetail);
    }

    boolean isInBackoff() {
        return this.rpcRetryTimer != null && this.rpcRetryTimer.isPending();
    }

    private void startRpcStream() {
        Preconditions.checkState((this.adsStream == null ? 1 : 0) != 0, (Object)"Previous adsStream has not been cleared yet");
        this.adsStream = this.serverInfo.useProtocolV3() ? new AdsStreamV3() : new AdsStreamV2();
        Context prevContext = this.context.attach();
        try {
            this.adsStream.start();
        }
        finally {
            this.context.detach(prevContext);
        }
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "ADS stream started");
        this.stopwatch.reset().start();
    }

    String getCurrentVersion(ResourceType type) {
        String version;
        switch (type) {
            case LDS: {
                version = this.ldsVersion;
                break;
            }
            case RDS: {
                version = this.rdsVersion;
                break;
            }
            case CDS: {
                version = this.cdsVersion;
                break;
            }
            case EDS: {
                version = this.edsVersion;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown resource type: " + (Object)((Object)type)));
            }
        }
        return version;
    }

    private final class AdsStreamV3
    extends AbstractAdsStream {
        private StreamObserver<io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest> requestWriter;

        private AdsStreamV3() {
        }

        @Override
        void start() {
            AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceStub stub = io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.AggregatedDiscoveryServiceGrpc.newStub((Channel)AbstractXdsClient.this.channel);
            StreamObserver<io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse> responseReader = new StreamObserver<io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse>(){

                public void onNext(final io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse response) {
                    AbstractXdsClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            ResourceType type = ResourceType.fromTypeUrl(response.getTypeUrl());
                            if (AbstractXdsClient.this.logger.isLoggable(XdsLogger.XdsLogLevel.DEBUG)) {
                                AbstractXdsClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received {0} response:\n{1}", new Object[]{type, MessagePrinter.print(response)});
                            }
                            AdsStreamV3.this.handleRpcResponse(type, response.getVersionInfo(), response.getResourcesList(), response.getNonce());
                        }
                    });
                }

                public void onError(final Throwable t) {
                    AbstractXdsClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            AdsStreamV3.this.handleRpcError(t);
                        }
                    });
                }

                public void onCompleted() {
                    AbstractXdsClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            AdsStreamV3.this.handleRpcCompleted();
                        }
                    });
                }
            };
            this.requestWriter = ((AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceStub)stub.withWaitForReady()).streamAggregatedResources(responseReader);
        }

        @Override
        void sendDiscoveryRequest(ResourceType type, String versionInfo, Collection<String> resources, String nonce, @Nullable String errorDetail) {
            Preconditions.checkState((this.requestWriter != null ? 1 : 0) != 0, (Object)"ADS stream has not been started");
            DiscoveryRequest.Builder builder = io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest.newBuilder().setVersionInfo(versionInfo).setNode(AbstractXdsClient.this.bootstrapNode.toEnvoyProtoNode()).addAllResourceNames(resources).setTypeUrl(type.typeUrl()).setResponseNonce(nonce);
            if (errorDetail != null) {
                com.google.rpc.Status error = com.google.rpc.Status.newBuilder().setCode(3).setMessage(errorDetail).build();
                builder.setErrorDetail(error);
            }
            io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest request = builder.build();
            this.requestWriter.onNext((Object)request);
            if (AbstractXdsClient.this.logger.isLoggable(XdsLogger.XdsLogLevel.DEBUG)) {
                AbstractXdsClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sent DiscoveryRequest\n{0}", MessagePrinter.print(request));
            }
        }

        @Override
        void sendError(Exception error) {
            this.requestWriter.onError((Throwable)error);
        }
    }

    private final class AdsStreamV2
    extends AbstractAdsStream {
        private StreamObserver<DiscoveryRequest> requestWriter;

        private AdsStreamV2() {
        }

        @Override
        void start() {
            AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceStub stub = AggregatedDiscoveryServiceGrpc.newStub((Channel)AbstractXdsClient.this.channel);
            StreamObserver<DiscoveryResponse> responseReaderV2 = new StreamObserver<DiscoveryResponse>(){

                public void onNext(final DiscoveryResponse response) {
                    AbstractXdsClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            ResourceType type = ResourceType.fromTypeUrl(response.getTypeUrl());
                            if (AbstractXdsClient.this.logger.isLoggable(XdsLogger.XdsLogLevel.DEBUG)) {
                                AbstractXdsClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received {0} response:\n{1}", new Object[]{type, MessagePrinter.print(response)});
                            }
                            AdsStreamV2.this.handleRpcResponse(type, response.getVersionInfo(), response.getResourcesList(), response.getNonce());
                        }
                    });
                }

                public void onError(final Throwable t) {
                    AbstractXdsClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            AdsStreamV2.this.handleRpcError(t);
                        }
                    });
                }

                public void onCompleted() {
                    AbstractXdsClient.this.syncContext.execute(new Runnable(){

                        @Override
                        public void run() {
                            AdsStreamV2.this.handleRpcCompleted();
                        }
                    });
                }
            };
            this.requestWriter = ((AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceStub)stub.withWaitForReady()).streamAggregatedResources(responseReaderV2);
        }

        @Override
        void sendDiscoveryRequest(ResourceType type, String versionInfo, Collection<String> resources, String nonce, @Nullable String errorDetail) {
            Preconditions.checkState((this.requestWriter != null ? 1 : 0) != 0, (Object)"ADS stream has not been started");
            DiscoveryRequest.Builder builder = DiscoveryRequest.newBuilder().setVersionInfo(versionInfo).setNode(AbstractXdsClient.this.bootstrapNode.toEnvoyProtoNodeV2()).addAllResourceNames(resources).setTypeUrl(type.typeUrlV2()).setResponseNonce(nonce);
            if (errorDetail != null) {
                com.google.rpc.Status error = com.google.rpc.Status.newBuilder().setCode(3).setMessage(errorDetail).build();
                builder.setErrorDetail(error);
            }
            DiscoveryRequest request = builder.build();
            this.requestWriter.onNext((Object)request);
            if (AbstractXdsClient.this.logger.isLoggable(XdsLogger.XdsLogLevel.DEBUG)) {
                AbstractXdsClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sent DiscoveryRequest\n{0}", MessagePrinter.print(request));
            }
        }

        @Override
        void sendError(Exception error) {
            this.requestWriter.onError((Throwable)error);
        }
    }

    private abstract class AbstractAdsStream {
        private boolean responseReceived;
        private boolean closed;
        private String ldsRespNonce = "";
        private String rdsRespNonce = "";
        private String cdsRespNonce = "";
        private String edsRespNonce = "";

        private AbstractAdsStream() {
        }

        abstract void start();

        abstract void sendError(Exception var1);

        abstract void sendDiscoveryRequest(ResourceType var1, String var2, Collection<String> var3, String var4, @Nullable String var5);

        final void sendDiscoveryRequest(ResourceType type, Collection<String> resources) {
            String nonce;
            switch (type) {
                case LDS: {
                    nonce = this.ldsRespNonce;
                    break;
                }
                case RDS: {
                    nonce = this.rdsRespNonce;
                    break;
                }
                case CDS: {
                    nonce = this.cdsRespNonce;
                    break;
                }
                case EDS: {
                    nonce = this.edsRespNonce;
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unknown resource type: " + (Object)((Object)type)));
                }
            }
            AbstractXdsClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending {0} request for resources: {1}", new Object[]{type, resources});
            this.sendDiscoveryRequest(type, AbstractXdsClient.this.getCurrentVersion(type), resources, nonce, null);
        }

        final void handleRpcResponse(ResourceType type, String versionInfo, List<Any> resources, String nonce) {
            if (this.closed) {
                return;
            }
            this.responseReceived = true;
            switch (type) {
                case LDS: {
                    this.ldsRespNonce = nonce;
                    AbstractXdsClient.this.xdsResponseHandler.handleLdsResponse(AbstractXdsClient.this.serverInfo, versionInfo, resources, nonce);
                    break;
                }
                case RDS: {
                    this.rdsRespNonce = nonce;
                    AbstractXdsClient.this.xdsResponseHandler.handleRdsResponse(AbstractXdsClient.this.serverInfo, versionInfo, resources, nonce);
                    break;
                }
                case CDS: {
                    this.cdsRespNonce = nonce;
                    AbstractXdsClient.this.xdsResponseHandler.handleCdsResponse(AbstractXdsClient.this.serverInfo, versionInfo, resources, nonce);
                    break;
                }
                case EDS: {
                    this.edsRespNonce = nonce;
                    AbstractXdsClient.this.xdsResponseHandler.handleEdsResponse(AbstractXdsClient.this.serverInfo, versionInfo, resources, nonce);
                    break;
                }
                default: {
                    AbstractXdsClient.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Ignore an unknown type of DiscoveryResponse");
                }
            }
        }

        final void handleRpcError(Throwable t) {
            this.handleRpcStreamClosed(Status.fromThrowable((Throwable)t));
        }

        final void handleRpcCompleted() {
            this.handleRpcStreamClosed(Status.UNAVAILABLE.withDescription("Closed by server"));
        }

        private void handleRpcStreamClosed(Status error) {
            Preconditions.checkArgument((!error.isOk() ? 1 : 0) != 0, (Object)"unexpected OK status");
            if (this.closed) {
                return;
            }
            AbstractXdsClient.this.logger.log(XdsLogger.XdsLogLevel.ERROR, "ADS stream closed with status {0}: {1}. Cause: {2}", error.getCode(), error.getDescription(), error.getCause());
            this.closed = true;
            AbstractXdsClient.this.xdsResponseHandler.handleStreamClosed(error);
            this.cleanUp();
            if (this.responseReceived || AbstractXdsClient.this.retryBackoffPolicy == null) {
                AbstractXdsClient.this.retryBackoffPolicy = AbstractXdsClient.this.backoffPolicyProvider.get();
            }
            long delayNanos = Math.max(0L, AbstractXdsClient.this.retryBackoffPolicy.nextBackoffNanos() - AbstractXdsClient.this.stopwatch.elapsed(TimeUnit.NANOSECONDS));
            AbstractXdsClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Retry ADS stream in {0} ns", delayNanos);
            AbstractXdsClient.this.rpcRetryTimer = AbstractXdsClient.this.syncContext.schedule((Runnable)new RpcRetryTask(), delayNanos, TimeUnit.NANOSECONDS, AbstractXdsClient.this.timeService);
        }

        private void close(Exception error) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            this.sendError(error);
        }

        private void cleanUp() {
            if (AbstractXdsClient.this.adsStream == this) {
                AbstractXdsClient.this.adsStream = null;
            }
        }
    }

    static enum ResourceType {
        UNKNOWN,
        LDS,
        RDS,
        CDS,
        EDS;


        String typeUrl() {
            switch (this) {
                case LDS: {
                    return AbstractXdsClient.ADS_TYPE_URL_LDS;
                }
                case RDS: {
                    return AbstractXdsClient.ADS_TYPE_URL_RDS;
                }
                case CDS: {
                    return AbstractXdsClient.ADS_TYPE_URL_CDS;
                }
                case EDS: {
                    return AbstractXdsClient.ADS_TYPE_URL_EDS;
                }
            }
            throw new AssertionError((Object)("Unknown or missing case in enum switch: " + (Object)((Object)this)));
        }

        String typeUrlV2() {
            switch (this) {
                case LDS: {
                    return AbstractXdsClient.ADS_TYPE_URL_LDS_V2;
                }
                case RDS: {
                    return AbstractXdsClient.ADS_TYPE_URL_RDS_V2;
                }
                case CDS: {
                    return AbstractXdsClient.ADS_TYPE_URL_CDS_V2;
                }
                case EDS: {
                    return AbstractXdsClient.ADS_TYPE_URL_EDS_V2;
                }
            }
            throw new AssertionError((Object)("Unknown or missing case in enum switch: " + (Object)((Object)this)));
        }

        @VisibleForTesting
        static ResourceType fromTypeUrl(String typeUrl) {
            switch (typeUrl) {
                case "type.googleapis.com/envoy.config.listener.v3.Listener": 
                case "type.googleapis.com/envoy.api.v2.Listener": {
                    return LDS;
                }
                case "type.googleapis.com/envoy.config.route.v3.RouteConfiguration": 
                case "type.googleapis.com/envoy.api.v2.RouteConfiguration": {
                    return RDS;
                }
                case "type.googleapis.com/envoy.config.cluster.v3.Cluster": 
                case "type.googleapis.com/envoy.api.v2.Cluster": {
                    return CDS;
                }
                case "type.googleapis.com/envoy.config.endpoint.v3.ClusterLoadAssignment": 
                case "type.googleapis.com/envoy.api.v2.ClusterLoadAssignment": {
                    return EDS;
                }
            }
            return UNKNOWN;
        }
    }

    @VisibleForTesting
    final class RpcRetryTask
    implements Runnable {
        RpcRetryTask() {
        }

        @Override
        public void run() {
            if (AbstractXdsClient.this.shutdown) {
                return;
            }
            AbstractXdsClient.this.startRpcStream();
            for (ResourceType type : ResourceType.values()) {
                Collection<String> resources;
                if (type == ResourceType.UNKNOWN || (resources = AbstractXdsClient.this.resourceStore.getSubscribedResources(AbstractXdsClient.this.serverInfo, type)) == null) continue;
                AbstractXdsClient.this.adsStream.sendDiscoveryRequest(type, resources);
            }
            AbstractXdsClient.this.xdsResponseHandler.handleStreamRestarted(AbstractXdsClient.this.serverInfo);
        }
    }
}

