/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.grpc.ConnectivityState;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerRegistry;
import io.grpc.Status;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.InternalXdsAttributes;
import io.grpc.xds.Locality;
import io.grpc.xds.WeightedTargetLoadBalancerProvider;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsSubchannelPickers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

final class WrrLocalityLoadBalancer
extends LoadBalancer {
    private final XdsLogger logger;
    private final LoadBalancer.Helper helper;
    private final GracefulSwitchLoadBalancer switchLb;
    private final LoadBalancerRegistry lbRegistry;

    WrrLocalityLoadBalancer(LoadBalancer.Helper helper) {
        this(helper, LoadBalancerRegistry.getDefaultRegistry());
    }

    WrrLocalityLoadBalancer(LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.lbRegistry = lbRegistry;
        this.switchLb = new GracefulSwitchLoadBalancer(helper);
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"xds-wrr-locality-lb", (String)helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    public boolean acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        WrrLocalityConfig wrrLocalityConfig = (WrrLocalityConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        Map localityWeights = (Map)resolvedAddresses.getAttributes().get(InternalXdsAttributes.ATTR_LOCALITY_WEIGHTS);
        if (localityWeights == null) {
            Status unavailable = Status.UNAVAILABLE.withDescription("wrr_locality error: no locality weights provided");
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(unavailable));
            return false;
        }
        HashMap<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection> weightedPolicySelections = new HashMap<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection>();
        for (Locality locality : localityWeights.keySet()) {
            weightedPolicySelections.put(locality.toString(), new WeightedTargetLoadBalancerProvider.WeightedPolicySelection((Integer)localityWeights.get(locality), wrrLocalityConfig.childPolicy));
        }
        resolvedAddresses = resolvedAddresses.toBuilder().setAttributes(resolvedAddresses.getAttributes().toBuilder().discard(InternalXdsAttributes.ATTR_LOCALITY_WEIGHTS).build()).build();
        this.switchLb.switchTo((LoadBalancer.Factory)this.lbRegistry.getProvider("weighted_target_experimental"));
        this.switchLb.handleResolvedAddresses(resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig((Object)new WeightedTargetLoadBalancerProvider.WeightedTargetConfig(weightedPolicySelections)).build());
        return true;
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        this.switchLb.handleNameResolutionError(error);
    }

    public void shutdown() {
        this.switchLb.shutdown();
    }

    static final class WrrLocalityConfig {
        final ServiceConfigUtil.PolicySelection childPolicy;

        WrrLocalityConfig(ServiceConfigUtil.PolicySelection childPolicy) {
            this.childPolicy = childPolicy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WrrLocalityConfig that = (WrrLocalityConfig)o;
            return Objects.equals(this.childPolicy, that.childPolicy);
        }

        public int hashCode() {
            return Objects.hashCode(this.childPolicy);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("childPolicy", (Object)this.childPolicy).toString();
        }
    }
}

